/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.TreeSet;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.apache.sling.feature.scanner.PackageInfo;

public class ListExportedPackages
implements AnalyserTask {
    @Override
    public String getId() {
        return "exported-packages";
    }

    @Override
    public String getName() {
        return "List exported packages check";
    }

    @Override
    public void execute(AnalyserTaskContext ctx) throws Exception {
        TreeSet<String> packages = new TreeSet<String>();
        for (BundleDescriptor bd : ctx.getFeatureDescriptor().getBundleDescriptors()) {
            for (PackageInfo packageInfo : bd.getExportedPackages()) {
                packages.add(packageInfo.getName());
            }
        }
        File f = new File("packages.txt");
        if (f.exists()) {
            throw new IOException("File " + f.getAbsolutePath() + " already exists. This plugin does not overwrite an existing file");
        }
        try (FileWriter fw = new FileWriter(f);){
            for (String string : packages) {
                fw.write(string);
                fw.write(System.getProperty("line.separator"));
            }
        }
        ctx.reportWarning("Finished writing exported packages to " + f.getAbsolutePath());
    }
}

