/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.analyser.task.impl.AbstractApiRegionsAnalyserTask;
import org.apache.sling.feature.analyser.task.impl.ApiRegions;

public class CheckApiRegionsDuplicates
extends AbstractApiRegionsAnalyserTask {
    @Override
    public String getId() {
        return "api-regions-duplicates";
    }

    @Override
    public String getName() {
        return "Api Regions duplicates analyser task";
    }

    @Override
    protected void execute(ApiRegions apiRegions, AnalyserTaskContext ctx) throws Exception {
        ArrayList<String> sourceRegions = new ArrayList<String>(apiRegions.getRegions());
        for (int i = 0; i < sourceRegions.size(); ++i) {
            String sourceRegion = (String)sourceRegions.get(i);
            List targetRegions = sourceRegions.subList(i + 1, sourceRegions.size());
            for (String targetRegion : targetRegions) {
                Set<String> intersection;
                if (sourceRegion.equals(targetRegion) || (intersection = CheckApiRegionsDuplicates.calculateIntersection(apiRegions.getApis(sourceRegion), apiRegions.getApis(targetRegion))).isEmpty()) continue;
                Formatter formatter = new Formatter();
                formatter.format("Regions '%s' and '%s' defined in feature '%s' declare both %s package(s):%n", sourceRegion, targetRegion, ctx.getFeature().getId(), intersection.size());
                intersection.forEach(api -> formatter.format(" * %s%n", api));
                ctx.reportError(formatter.toString());
                formatter.close();
            }
        }
    }

    private static Set<String> calculateIntersection(Set<String> source, Set<String> target) {
        HashSet<String> intersection = new HashSet<String>();
        for (String packageName : source) {
            if (!target.contains(packageName)) continue;
            intersection.add(packageName);
        }
        return intersection;
    }
}

