/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import java.util.List;
import java.util.Set;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.analyser.task.impl.AbstractApiRegionsAnalyserTask;
import org.apache.sling.feature.analyser.task.impl.ApiRegions;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.apache.sling.feature.scanner.FeatureDescriptor;
import org.apache.sling.feature.scanner.PackageInfo;

public class CheckApiRegionsDependencies
extends AbstractApiRegionsAnalyserTask {
    @Override
    public String getId() {
        return "api-regions-dependencies";
    }

    @Override
    public String getName() {
        return "Api Regions dependecies analyser task";
    }

    @Override
    protected void execute(ApiRegions apiRegions, AnalyserTaskContext ctx) throws Exception {
        List<String> regions = apiRegions.getRegions();
        for (int i = 0; i < regions.size(); ++i) {
            for (int j = i + 1; j < regions.size(); ++j) {
                this.execute(ctx, apiRegions, regions.get(i), regions.get(j));
            }
        }
    }

    private void execute(AnalyserTaskContext ctx, ApiRegions apiRegions, String exportingApisName, String hidingApisName) {
        Set<String> exportingApis = apiRegions.getApis(exportingApisName);
        Set<String> hidingApis = apiRegions.getApis(hidingApisName);
        FeatureDescriptor featureDescriptor = ctx.getFeatureDescriptor();
        for (BundleDescriptor bundleDescriptor : featureDescriptor.getBundleDescriptors()) {
            for (PackageInfo packageInfo : bundleDescriptor.getExportedPackages()) {
                String exportedPackage = packageInfo.getName();
                if (!exportingApis.contains(exportedPackage)) continue;
                if (hidingApis.contains(exportedPackage)) {
                    String errorMessage = String.format("Bundle '%s' (defined in feature '%s') declares '%s' in the '%s' header that is enlisted in both exporting '%s' and hiding '%s' APIs regions, please adjust Feature settings", bundleDescriptor.getArtifact().getId(), ctx.getFeature().getId(), exportedPackage, "Export-Package", exportingApisName, hidingApisName);
                    ctx.reportError(errorMessage);
                    continue;
                }
                for (String uses : packageInfo.getUses()) {
                    if (!hidingApis.contains(uses)) continue;
                    String errorMessage = String.format("Bundle '%s' (defined in feature '%s') declares '%s' in the '%s' header, enlisted in the '%s' region, which uses '%s' package that is in the '%s' region", bundleDescriptor.getArtifact().getId(), ctx.getFeature().getId(), exportedPackage, "Export-Package", exportingApisName, uses, hidingApisName);
                    ctx.reportError(errorMessage);
                }
            }
        }
    }
}

