/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.json.Json;
import javax.json.stream.JsonParser;

final class ApiRegions {
    private static final String NAME_KEY = "name";
    private static final String EXPORTS_KEY = "exports";
    private final Map<String, Set<String>> apis = new LinkedHashMap<String, Set<String>>();

    static ApiRegions fromJson(String jsonRepresentation) {
        ApiRegions apiRegions = new ApiRegions();
        String region = null;
        LinkedList<String> apis = null;
        JsonParser parser = Json.createParser((Reader)new StringReader(jsonRepresentation));
        while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            if (JsonParser.Event.KEY_NAME == event) {
                switch (parser.getString()) {
                    case "name": {
                        parser.next();
                        region = parser.getString();
                        break;
                    }
                    case "exports": {
                        apis = new LinkedList<String>();
                        parser.next();
                        while (parser.hasNext() && JsonParser.Event.VALUE_STRING == parser.next()) {
                            String api = parser.getString();
                            if ('#' == api.charAt(0)) continue;
                            apis.add(api);
                        }
                        break;
                    }
                }
                continue;
            }
            if (JsonParser.Event.END_OBJECT != event) continue;
            if (region != null && apis != null) {
                apiRegions.add(region, apis);
            }
            region = null;
            apis = null;
        }
        return apiRegions;
    }

    ApiRegions() {
    }

    void add(String region, Collection<String> exportedApis) {
        this.apis.computeIfAbsent(region, k -> new TreeSet()).addAll(exportedApis);
    }

    List<String> getRegions() {
        return new ArrayList<String>(this.apis.keySet());
    }

    Set<String> getApis(String region) {
        return this.apis.computeIfAbsent(region, k -> Collections.emptySet());
    }

    void remove(String packageName) {
        this.apis.values().forEach(apis -> apis.remove(packageName));
    }

    boolean isEmpty() {
        for (Set<String> packages : this.apis.values()) {
            if (packages.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.apis.toString().replace(',', '\n');
    }
}

