/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import java.util.Collection;
import java.util.Formatter;
import java.util.Set;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.analyser.task.impl.AbstractApiRegionsAnalyserTask;
import org.apache.sling.feature.analyser.task.impl.ApiRegions;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.apache.sling.feature.scanner.FeatureDescriptor;
import org.apache.sling.feature.scanner.PackageInfo;

public class CheckApiRegions
extends AbstractApiRegionsAnalyserTask {
    @Override
    public String getId() {
        return "api-regions";
    }

    @Override
    public String getName() {
        return "Api Regions analyser task";
    }

    @Override
    protected void execute(ApiRegions apiRegions, AnalyserTaskContext ctx) throws Exception {
        FeatureDescriptor featureDescriptor = ctx.getFeatureDescriptor();
        for (BundleDescriptor bundleDescriptor : featureDescriptor.getBundleDescriptors()) {
            for (PackageInfo packageInfo : bundleDescriptor.getExportedPackages()) {
                String exportedPackage = packageInfo.getName();
                apiRegions.remove(exportedPackage);
            }
        }
        if (!apiRegions.isEmpty()) {
            for (String region : apiRegions.getRegions()) {
                Set<String> apis = apiRegions.getApis(region);
                if (apis.isEmpty()) continue;
                Formatter formatter = new Formatter();
                formatter.format("Region '%s' defined in feature '%s' declares %s package%s which %s not exported by any bundle:%n", region, ctx.getFeature().getId(), apis.size(), CheckApiRegions.getExtension(apis, "", "s"), CheckApiRegions.getExtension(apis, "is", "are"));
                apis.forEach(api -> formatter.format(" * %s%n", api));
                ctx.reportError(formatter.toString());
                formatter.close();
            }
        }
    }

    private static <T> String getExtension(Collection<T> collection, String singular, String plural) {
        return collection.size() > 1 ? plural : singular;
    }
}

