/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.scanner;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.sling.feature.scanner.ArtifactDescriptor;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.apache.sling.feature.scanner.Descriptor;

public abstract class ContainerDescriptor
extends Descriptor {
    private final Set<BundleDescriptor> bundles = new HashSet<BundleDescriptor>();
    private final Set<ArtifactDescriptor> artifacts = new HashSet<ArtifactDescriptor>();

    protected ContainerDescriptor(String name) {
        super(name);
    }

    public final Set<BundleDescriptor> getBundleDescriptors() {
        return this.isLocked() ? Collections.unmodifiableSet(this.bundles) : this.bundles;
    }

    public final Set<ArtifactDescriptor> getArtifactDescriptors() {
        return this.isLocked() ? Collections.unmodifiableSet(this.artifacts) : this.artifacts;
    }

    @Override
    public void lock() {
        if (this.isLocked()) {
            return;
        }
        for (BundleDescriptor bd : this.bundles) {
            this.aggregate(bd);
        }
        for (ArtifactDescriptor d : this.artifacts) {
            this.aggregate(d);
        }
        super.lock();
    }
}

