/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.scanner;

import java.util.Collections;
import java.util.Set;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class PackageInfo
implements Comparable<PackageInfo> {
    private final boolean optional;
    private final String name;
    private final String version;
    private final Set<String> uses;

    public PackageInfo(String name, String version, boolean optional) {
        this(name, version, optional, Collections.emptySet());
    }

    public PackageInfo(String name, String version, boolean optional, Set<String> uses) {
        this.name = name;
        this.version = version;
        this.optional = optional;
        this.uses = uses;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public Version getPackageVersion() {
        if (this.version == null) {
            return null;
        }
        return new Version(this.version);
    }

    public VersionRange getPackageVersionRange() {
        if (this.version == null) {
            return null;
        }
        return new VersionRange(this.version);
    }

    public Set<String> getUses() {
        return this.uses;
    }

    public String toString() {
        return "Package " + this.name + ";version=" + this.version + (this.optional ? " (optional)" : "");
    }

    @Override
    public int compareTo(PackageInfo o) {
        int result = this.name.compareTo(o.name);
        if (result == 0) {
            result = this.version.compareTo(o.version);
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.optional ? 1231 : 1237);
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PackageInfo other = (PackageInfo)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.optional != other.optional) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

