/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.jar.Manifest;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.scanner.BundleDescriptor;

public class CheckBundlesForInitialContent
implements AnalyserTask {
    private static final String CONTENT_HEADER = "Sling-Initial-Content";
    private static final String PATH_DIRECTIVE = "path";

    @Override
    public String getName() {
        return "Bundle Initial Content Check";
    }

    @Override
    public String getId() {
        return "bundle-content";
    }

    @Override
    public void execute(AnalyserTaskContext ctx) {
        for (BundleDescriptor info : ctx.getFeatureDescriptor().getBundleDescriptors()) {
            List<String> initialContent = this.extractInitialContent(info.getManifest());
            if (initialContent.isEmpty()) continue;
            ctx.reportWarning("Found initial content in " + info.getArtifact() + " : " + initialContent);
        }
    }

    private List<String> extractInitialContent(Manifest m) {
        String root;
        ArrayList<String> initialContent = new ArrayList<String>();
        if (m != null && (root = m.getMainAttributes().getValue(CONTENT_HEADER)) != null) {
            Clause[] clauses;
            for (Clause entry : clauses = Parser.parseHeader(root)) {
                String path = entry.getDirective(PATH_DIRECTIVE);
                if (path == null) {
                    path = "/";
                } else if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                initialContent.add(path);
            }
        }
        return initialContent;
    }
}

