/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import javax.json.stream.JsonParsingException;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.Extensions;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.analyser.task.impl.ApiRegions;

public abstract class AbstractApiRegionsAnalyserTask
implements AnalyserTask {
    protected static final String API_REGIONS_KEY = "api-regions";

    @Override
    public final void execute(AnalyserTaskContext ctx) throws Exception {
        ApiRegions apiRegions;
        Feature feature = ctx.getFeature();
        Extensions extensions = feature.getExtensions();
        Extension apiRegionsExtension = extensions.getByName(API_REGIONS_KEY);
        if (apiRegionsExtension == null) {
            return;
        }
        String jsonRepresentation = apiRegionsExtension.getJSON();
        if (jsonRepresentation == null || jsonRepresentation.isEmpty()) {
            return;
        }
        try {
            apiRegions = ApiRegions.fromJson(jsonRepresentation);
        }
        catch (JsonParsingException e) {
            ctx.reportError("API Regions '" + jsonRepresentation + "' does not represent a valid JSON 'api-regions': " + e.getMessage());
            return;
        }
        this.execute(apiRegions, ctx);
    }

    protected abstract void execute(ApiRegions var1, AnalyserTaskContext var2) throws Exception;
}

