/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.scanner.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.scanner.impl.BundleDescriptorImpl;
import org.apache.sling.feature.scanner.impl.ContentPackageDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentPackageScanner {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final byte[] buffer = new byte[65536];

    public Set<ContentPackageDescriptor> scan(Artifact desc, File file) throws IOException {
        if (!file.getName().endsWith(".zip")) {
            throw new IOException("Artifact seems to be no content package (not a zip file): " + desc.getId().toMvnId());
        }
        HashSet<ContentPackageDescriptor> contentPackages = new HashSet<ContentPackageDescriptor>();
        ContentPackageDescriptor cp = new ContentPackageDescriptor(file.getName());
        int lastDot = file.getName().lastIndexOf(".");
        cp.setName(file.getName().substring(0, lastDot));
        cp.setArtifact(desc);
        cp.setArtifactFile(file);
        this.extractContentPackage(cp, contentPackages, file);
        contentPackages.add(cp);
        cp.lock();
        return contentPackages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractContentPackage(ContentPackageDescriptor cp, Set<ContentPackageDescriptor> infos, File archive) throws IOException {
        this.logger.debug("Analyzing Content Package {}", (Object)archive.getName());
        File tempDir = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
        try {
            File toDir = new File(tempDir, archive.getName());
            toDir.mkdirs();
            ArrayList<File> toProcess = new ArrayList<File>();
            try (ZipInputStream zis = new ZipInputStream(new FileInputStream(archive));){
                boolean done = false;
                while (!done) {
                    ZipEntry entry = zis.getNextEntry();
                    if (entry == null) {
                        done = true;
                        continue;
                    }
                    String entryName = entry.getName();
                    if (!entryName.endsWith("/") && entryName.startsWith("jcr_root/")) {
                        String contentPath = entryName.substring(8);
                        FileType fileType = null;
                        if (entryName.endsWith(".zip")) {
                            fileType = FileType.PACKAGE;
                        } else if (entryName.startsWith("jcr_root/libs/") || entryName.startsWith("jcr_root/apps/")) {
                            int endSlashPos;
                            int pos;
                            boolean isInstall;
                            boolean bl = isInstall = entryName.indexOf("/install/") != -1;
                            if (!isInstall && (pos = entryName.indexOf("/install.")) != -1 && (endSlashPos = entryName.indexOf(47, pos + 1)) != -1) {
                                isInstall = true;
                            }
                            if (!isInstall) {
                                boolean bl2 = isInstall = entryName.indexOf("/config/") != -1;
                                if (!isInstall && (pos = entryName.indexOf("/config.")) != -1 && (endSlashPos = entryName.indexOf(47, pos + 1)) != -1) {
                                    isInstall = true;
                                }
                            }
                            if (isInstall) {
                                if (entryName.endsWith(".jar")) {
                                    fileType = FileType.BUNDLE;
                                } else if (entryName.endsWith(".xml") || entryName.endsWith(".config")) {
                                    fileType = FileType.CONFIG;
                                }
                            }
                        }
                        if (fileType != null) {
                            this.logger.debug("- extracting : {}", (Object)entryName);
                            File newFile = new File(toDir, entryName.replace('/', File.separatorChar));
                            newFile.getParentFile().mkdirs();
                            try (FileOutputStream fos = new FileOutputStream(newFile);){
                                int len;
                                while ((len = zis.read(this.buffer)) > -1) {
                                    fos.write(this.buffer, 0, len);
                                }
                            }
                            if (fileType == FileType.BUNDLE) {
                                int startLevel = 20;
                                int lastSlash = contentPath.lastIndexOf(47);
                                int nextSlash = contentPath.lastIndexOf(47, lastSlash - 1);
                                String part = contentPath.substring(nextSlash + 1, lastSlash);
                                try {
                                    startLevel = Integer.valueOf(part);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                Artifact bundle = new Artifact(this.extractArtifactId(tempDir, newFile));
                                BundleDescriptorImpl info = new BundleDescriptorImpl(bundle, newFile, startLevel);
                                bundle.getMetadata().put("content-package", cp.getArtifact().getId().toMvnId());
                                bundle.getMetadata().put("content-path", contentPath);
                                cp.bundles.add(info);
                            } else if (fileType == FileType.CONFIG) {
                                Configuration configEntry = this.process(newFile, cp.getArtifact(), contentPath);
                                if (configEntry != null) {
                                    cp.configs.add(configEntry);
                                }
                            } else if (fileType == FileType.PACKAGE) {
                                toProcess.add(newFile);
                            }
                        }
                    }
                    zis.closeEntry();
                }
            }
            for (File f : toProcess) {
                this.extractContentPackage(cp, infos, f);
                ContentPackageDescriptor i = new ContentPackageDescriptor(f.getName());
                int lastDot = f.getName().lastIndexOf(".");
                i.setName(f.getName().substring(0, lastDot));
                i.setArtifactFile(f);
                i.setContentPackageInfo(cp.getArtifact(), f.getName());
                infos.add(i);
                i.lock();
            }
        }
        finally {
            this.deleteRecursive(tempDir);
        }
    }

    private boolean deleteRecursive(File file) {
        if (file.isDirectory()) {
            File[] childs = file.listFiles();
            if (childs != null) {
                for (File child : childs) {
                    if (this.deleteRecursive(child)) continue;
                    return false;
                }
                return file.delete();
            }
            return false;
        }
        return file.delete();
    }

    private ArtifactId extractArtifactId(File tempDir, File bundleFile) throws IOException {
        File mavenDir;
        this.logger.debug("Extracting Bundle {}", (Object)bundleFile.getName());
        File toDir = new File(tempDir, bundleFile.getName());
        toDir.mkdirs();
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(bundleFile));){
            boolean done = false;
            while (!done) {
                File[] entry = zis.getNextEntry();
                if (entry == null) {
                    done = true;
                    continue;
                }
                String entryName = entry.getName();
                if (!entryName.endsWith("/") && entryName.startsWith("META-INF/maven/") && entryName.endsWith("/pom.properties")) {
                    this.logger.debug("- extracting : {}", (Object)entryName);
                    File newFile = new File(toDir, entryName.replace('/', File.separatorChar));
                    newFile.getParentFile().mkdirs();
                    Throwable throwable = null;
                    try (FileOutputStream fos = new FileOutputStream(newFile);){
                        int len;
                        while ((len = zis.read(this.buffer)) > -1) {
                            fos.write(this.buffer, 0, len);
                        }
                    }
                    catch (Throwable len) {
                        Throwable throwable2 = len;
                        throw len;
                    }
                }
                zis.closeEntry();
            }
        }
        File metaInfDir = new File(toDir, "META-INF");
        if (metaInfDir.exists() && (mavenDir = new File(metaInfDir, "maven")).exists()) {
            File groupDir = null;
            for (File d : mavenDir.listFiles()) {
                if (!d.isDirectory() || d.getName().startsWith(".")) continue;
                groupDir = d;
                break;
            }
            if (groupDir != null) {
                File propsFile;
                File artifactDir = null;
                for (File file : groupDir.listFiles()) {
                    if (!file.isDirectory() || file.getName().startsWith(".")) continue;
                    artifactDir = file;
                    break;
                }
                if (artifactDir != null && (propsFile = new File(artifactDir, "pom.properties")).exists()) {
                    String[] parts;
                    Properties props = new Properties();
                    Throwable throwable = null;
                    try (FileReader r = new FileReader(propsFile);){
                        props.load(r);
                    }
                    catch (Throwable len) {
                        Throwable throwable3 = len;
                        throw len;
                    }
                    String groupId = props.getProperty("groupId");
                    String string = props.getProperty("artifactId");
                    String version = props.getProperty("version");
                    String classifier = null;
                    int pos = bundleFile.getName().indexOf(version) + version.length();
                    if (bundleFile.getName().charAt(pos) == '-') {
                        classifier = bundleFile.getName().substring(pos + 1, bundleFile.getName().lastIndexOf(46));
                    }
                    if ((parts = version.split("\\.")).length == 4) {
                        int lastDot = version.lastIndexOf(46);
                        version = version.substring(0, lastDot) + '-' + version.substring(lastDot + 1);
                    }
                    if (groupId != null && string != null && version != null) {
                        return new ArtifactId(groupId, string, version, classifier, null);
                    }
                }
            }
        }
        throw new IOException(bundleFile.getName() + " has no maven coordinates!");
    }

    private Configuration process(File configFile, Artifact packageArtifact, String contentPath) throws IOException {
        String contents;
        boolean isConfig = true;
        if (configFile.getName().endsWith(".xml") && (contents = Files.readAllLines(configFile.toPath()).toString()).indexOf("jcr:primaryType=\"sling:OsgiConfig\"") == -1) {
            isConfig = false;
        }
        if (isConfig) {
            String id;
            if (".content.xml".equals(configFile.getName())) {
                int lastSlash = contentPath.lastIndexOf(47);
                int previousSlash = contentPath.lastIndexOf(47, lastSlash - 1);
                id = contentPath.substring(previousSlash + 1, lastSlash);
            } else {
                int lastDot = configFile.getName().lastIndexOf(46);
                id = configFile.getName().substring(0, lastDot);
            }
            int slashPos = id.indexOf(45);
            String pid = slashPos == -1 ? id : id.substring(0, slashPos) + '~' + id.substring(slashPos + 1);
            Configuration cfg = new Configuration(pid);
            cfg.getProperties().put(":configurator:feature:content-path", contentPath);
            cfg.getProperties().put(":configurator:feature:content-package", packageArtifact.getId().toMvnId());
            return cfg;
        }
        return null;
    }

    private static enum FileType {
        BUNDLE,
        CONFIG,
        PACKAGE;

    }
}

