/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.scanner.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.scanner.ArtifactDescriptor;
import org.apache.sling.feature.scanner.BundleDescriptor;

public class ContentPackageDescriptor
extends ArtifactDescriptor {
    private String name;
    public final List<BundleDescriptor> bundles = new ArrayList<BundleDescriptor>();
    public final List<Configuration> configs = new ArrayList<Configuration>();
    private File artifactFile;
    private Artifact artifact;
    private Artifact contentPackage;
    private String contentPath;

    public ContentPackageDescriptor(String name) {
        super(name);
    }

    @Override
    public File getArtifactFile() {
        return this.artifactFile;
    }

    @Override
    public Artifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(Artifact artifact) {
        this.checkLocked();
        this.artifact = artifact;
    }

    public void setArtifactFile(File artifactFile) {
        this.checkLocked();
        this.artifactFile = artifactFile;
    }

    public Artifact getContentPackage() {
        return this.contentPackage;
    }

    public String getContentPath() {
        return this.contentPath;
    }

    public boolean isEmbeddedInContentPackage() {
        return this.contentPath != null;
    }

    public void setContentPackageInfo(Artifact artifact, String path) {
        this.checkLocked();
        this.contentPackage = artifact;
        this.contentPath = path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.checkLocked();
        this.name = value;
    }

    public boolean hasEmbeddedArtifacts() {
        return !this.bundles.isEmpty() || !this.configs.isEmpty();
    }

    @Override
    public String toString() {
        return "ContentPackage [" + this.name + "]";
    }
}

