/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.scanner;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Bundles;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.Extensions;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.apache.sling.feature.scanner.ContainerDescriptor;
import org.apache.sling.feature.scanner.Descriptor;
import org.apache.sling.feature.scanner.FeatureDescriptor;
import org.apache.sling.feature.scanner.impl.BundleDescriptorImpl;
import org.apache.sling.feature.scanner.impl.FeatureDescriptorImpl;
import org.apache.sling.feature.scanner.spi.ExtensionScanner;
import org.apache.sling.feature.scanner.spi.FrameworkScanner;

public class Scanner {
    private final ArtifactProvider artifactProvider;
    private final List<ExtensionScanner> extensionScanners;
    private final List<FrameworkScanner> frameworkScanners;

    public Scanner(ArtifactProvider artifactProvider, List<ExtensionScanner> extensionScanners, List<FrameworkScanner> frameworkScanners) throws IOException {
        this.artifactProvider = artifactProvider;
        this.extensionScanners = extensionScanners == null ? Scanner.getServices(ExtensionScanner.class) : extensionScanners;
        this.frameworkScanners = frameworkScanners == null ? Scanner.getServices(FrameworkScanner.class) : frameworkScanners;
    }

    public Scanner(ArtifactProvider artifactProvider) throws IOException {
        this(artifactProvider, null, null);
    }

    private static <T> List<T> getServices(Class<T> clazz) {
        ServiceLoader<T> loader = ServiceLoader.load(clazz);
        ArrayList<T> list = new ArrayList<T>();
        for (T task : loader) {
            list.add(task);
        }
        return list;
    }

    public BundleDescriptor scan(Artifact bundle, int startLevel) throws IOException {
        File file = this.artifactProvider.provide(bundle.getId());
        if (file == null) {
            throw new IOException("Unable to find file for " + bundle.getId());
        }
        return new BundleDescriptorImpl(bundle, file, startLevel);
    }

    private void getBundleInfos(Bundles bundles, ContainerDescriptor desc) throws IOException {
        for (Map.Entry entry : bundles.getBundlesByStartOrder().entrySet()) {
            for (Artifact bundle : (List)entry.getValue()) {
                BundleDescriptor bundleDesc = this.scan(bundle, (Integer)entry.getKey());
                desc.getBundleDescriptors().add(bundleDesc);
            }
        }
    }

    private void scan(Feature f, Extensions extensions, ContainerDescriptor desc) throws IOException {
        for (Extension ext : extensions) {
            ExtensionScanner scanner;
            Descriptor extDesc = null;
            Iterator<ExtensionScanner> iterator = this.extensionScanners.iterator();
            while (iterator.hasNext() && (extDesc = (scanner = iterator.next()).scan(f, ext, this.artifactProvider)) == null) {
            }
            if (extDesc == null) {
                throw new IOException("No extension scanner found for extension named " + ext.getName() + " of type " + ext.getType().name());
            }
            desc.getRequirements().addAll(extDesc.getRequirements());
            desc.getCapabilities().addAll(extDesc.getCapabilities());
            desc.getExportedPackages().addAll(extDesc.getExportedPackages());
            desc.getImportedPackages().addAll(extDesc.getImportedPackages());
            desc.getDynamicImportedPackages().addAll(extDesc.getDynamicImportedPackages());
            desc.getArtifactDescriptors().addAll(((ContainerDescriptor)extDesc).getArtifactDescriptors());
            desc.getBundleDescriptors().addAll(((ContainerDescriptor)extDesc).getBundleDescriptors());
        }
    }

    private void compact(ContainerDescriptor desc) {
    }

    public FeatureDescriptor scan(Feature feature) throws IOException {
        FeatureDescriptorImpl desc = new FeatureDescriptorImpl(feature);
        this.getBundleInfos(feature.getBundles(), desc);
        this.scan(feature, feature.getExtensions(), desc);
        this.compact(desc);
        desc.lock();
        return desc;
    }

    public BundleDescriptor scan(ArtifactId framework, Map<String, String> props) throws IOException {
        FrameworkScanner scanner;
        BundleDescriptor fwk = null;
        Iterator<FrameworkScanner> iterator = this.frameworkScanners.iterator();
        while (iterator.hasNext() && (fwk = (scanner = iterator.next()).scan(framework, props, this.artifactProvider)) == null) {
        }
        if (fwk == null) {
            throw new IOException("No scanner found for framework " + framework.toMvnId());
        }
        return fwk;
    }
}

