/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.analyser.task.impl.ApiRegions;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.apache.sling.feature.scanner.PackageInfo;
import org.osgi.framework.Version;

public class CheckBundleExportsImports
implements AnalyserTask {
    private static final String FILE_STORAGE_CONFIG_KEY = "fileStorage";
    private static final String IGNORE_API_REGIONS_CONFIG_KEY = "ignoreAPIRegions";
    private static final String API_REGIONS = "api-regions";
    private static final String GLOBAL_REGION = "global";
    private static final String NO_REGION = " __NO_REGION__ ";
    private static final String OWN_FEATURE = " __OWN_FEATURE__ ";

    @Override
    public String getName() {
        return "Bundle Import/Export Check";
    }

    @Override
    public String getId() {
        return "bundle-packages";
    }

    private Report getReport(Map<BundleDescriptor, Report> reports, BundleDescriptor info) {
        Report report = reports.get(info);
        if (report == null) {
            report = new Report();
            reports.put(info, report);
        }
        return report;
    }

    private void checkForVersionOnExportedPackages(AnalyserTaskContext ctx, Map<BundleDescriptor, Report> reports) {
        for (BundleDescriptor info : ctx.getFeatureDescriptor().getBundleDescriptors()) {
            if (info.getExportedPackages() == null) continue;
            for (PackageInfo i : info.getExportedPackages()) {
                if (i.getPackageVersion().compareTo(Version.emptyVersion) != 0) continue;
                this.getReport(reports, (BundleDescriptor)info).exportWithoutVersion.add(i);
            }
        }
    }

    private void checkForVersionOnImportingPackages(AnalyserTaskContext ctx, Map<BundleDescriptor, Report> reports) {
        for (BundleDescriptor info : ctx.getFeatureDescriptor().getBundleDescriptors()) {
            if (info.getImportedPackages() == null) continue;
            for (PackageInfo i : info.getImportedPackages()) {
                if (i.getVersion() != null || i.getName().startsWith("javax.") || i.getName().startsWith("org.w3c.")) continue;
                this.getReport(reports, (BundleDescriptor)info).importWithoutVersion.add(i);
            }
        }
    }

    @Override
    public void execute(AnalyserTaskContext ctx) throws IOException {
        Map<String, Set<String>> featureToOriginalRegions;
        Map<String, Set<String>> bundleToOriginalFeatures;
        ApiRegions apiRegions;
        boolean ignoreAPIRegions = ctx.getConfiguration().getOrDefault(IGNORE_API_REGIONS_CONFIG_KEY, "false").equalsIgnoreCase("true");
        HashMap<BundleDescriptor, Report> reports = new HashMap<BundleDescriptor, Report>();
        this.checkForVersionOnExportedPackages(ctx, reports);
        this.checkForVersionOnImportingPackages(ctx, reports);
        TreeMap<Integer, ArrayList<BundleDescriptor>> bundlesMap = new TreeMap<Integer, ArrayList<BundleDescriptor>>();
        for (BundleDescriptor bi : ctx.getFeatureDescriptor().getBundleDescriptors()) {
            ArrayList<BundleDescriptor> list = (ArrayList<BundleDescriptor>)bundlesMap.get(bi.getBundleStartLevel());
            if (list == null) {
                list = new ArrayList<BundleDescriptor>();
                bundlesMap.put(bi.getBundleStartLevel(), list);
            }
            list.add(bi);
        }
        ArrayList<BundleDescriptor> exportingBundles = new ArrayList<BundleDescriptor>();
        if (ctx.getFrameworkDescriptor() != null) {
            exportingBundles.add(ctx.getFrameworkDescriptor());
        }
        if (ignoreAPIRegions) {
            apiRegions = new ApiRegions();
            bundleToOriginalFeatures = Collections.emptyMap();
            featureToOriginalRegions = Collections.emptyMap();
        } else {
            apiRegions = this.readAPIRegionsFromFeature(ctx);
            bundleToOriginalFeatures = this.readBundleOrigins(ctx);
            featureToOriginalRegions = this.readRegionOrigins(ctx);
        }
        for (Map.Entry entry : bundlesMap.entrySet()) {
            for (BundleDescriptor info : (List)entry.getValue()) {
                if (info.getExportedPackages() == null) continue;
                exportingBundles.add(info);
            }
            for (BundleDescriptor info : (List)entry.getValue()) {
                if (info.getImportedPackages() == null) continue;
                for (PackageInfo pck : info.getImportedPackages()) {
                    Map<BundleDescriptor, Set<String>> candidates = this.getCandidates(exportingBundles, pck, info, bundleToOriginalFeatures, featureToOriginalRegions, apiRegions);
                    if (candidates.isEmpty()) {
                        if (pck.isOptional()) {
                            this.getReport(reports, (BundleDescriptor)info).missingExportsForOptional.add(pck);
                            continue;
                        }
                        this.getReport(reports, (BundleDescriptor)info).missingExports.add(pck);
                        continue;
                    }
                    ArrayList<BundleDescriptor> matchingCandidates = new ArrayList<BundleDescriptor>();
                    HashSet<String> exportingRegions = new HashSet<String>();
                    HashSet<String> importingRegions = new HashSet<String>();
                    for (Map.Entry<BundleDescriptor, Set<String>> candidate : candidates.entrySet()) {
                        BundleDescriptor bd = candidate.getKey();
                        if (!bd.isExportingPackage(pck)) continue;
                        Set<String> exRegions = candidate.getValue();
                        if (exRegions.contains(NO_REGION)) {
                            matchingCandidates.add(bd);
                            continue;
                        }
                        if (exRegions.contains(GLOBAL_REGION)) {
                            matchingCandidates.add(bd);
                            continue;
                        }
                        if (exRegions.contains(OWN_FEATURE)) {
                            matchingCandidates.add(bd);
                            continue;
                        }
                        Set<String> imRegions = this.getBundleRegions(info, bundleToOriginalFeatures, featureToOriginalRegions);
                        exportingRegions.addAll(exRegions);
                        importingRegions.addAll(imRegions);
                        imRegions.retainAll(exRegions);
                        if (imRegions.isEmpty()) continue;
                        matchingCandidates.add(bd);
                    }
                    if (matchingCandidates.isEmpty()) {
                        if (pck.isOptional()) {
                            this.getReport(reports, (BundleDescriptor)info).missingExportsForOptional.add(pck);
                            continue;
                        }
                        this.getReport(reports, (BundleDescriptor)info).missingExportsWithVersion.add(pck);
                        this.getReport(reports, (BundleDescriptor)info).regionInfo.put(pck, new AbstractMap.SimpleEntry(exportingRegions, importingRegions));
                        continue;
                    }
                    if (matchingCandidates.size() <= 1) continue;
                    this.getReport(reports, (BundleDescriptor)info).exportMatchingSeveral.add(pck);
                }
            }
        }
        boolean errorReported = false;
        for (Map.Entry entry : reports.entrySet()) {
            String key = "Bundle " + ((BundleDescriptor)entry.getKey()).getArtifact().getId().getArtifactId() + ":" + ((BundleDescriptor)entry.getKey()).getArtifact().getId().getVersion();
            if (!((Report)entry.getValue()).importWithoutVersion.isEmpty()) {
                ctx.reportWarning(key + " is importing package(s) " + this.getPackageInfo(((Report)entry.getValue()).importWithoutVersion, false) + " without specifying a version range.");
            }
            if (!((Report)entry.getValue()).exportWithoutVersion.isEmpty()) {
                ctx.reportWarning(key + " is exporting package(s) " + this.getPackageInfo(((Report)entry.getValue()).importWithoutVersion, false) + " without a version.");
            }
            if (!((Report)entry.getValue()).missingExports.isEmpty()) {
                ctx.reportError(key + " is importing package(s) " + this.getPackageInfo(((Report)entry.getValue()).missingExports, false) + " in start level " + String.valueOf(((BundleDescriptor)entry.getKey()).getBundleStartLevel()) + " but no bundle is exporting these for that start level.");
                errorReported = true;
            }
            if (((Report)entry.getValue()).missingExportsWithVersion.isEmpty()) continue;
            StringBuilder message = new StringBuilder(key + " is importing package(s) " + this.getPackageInfo(((Report)entry.getValue()).missingExportsWithVersion, true) + " in start level " + String.valueOf(((BundleDescriptor)entry.getKey()).getBundleStartLevel()) + " but no visible bundle is exporting these for that start level in the required version range.");
            for (Map.Entry<PackageInfo, Map.Entry<Set<String>, Set<String>>> regionInfoEntry : ((Report)entry.getValue()).regionInfo.entrySet()) {
                PackageInfo pkg = regionInfoEntry.getKey();
                Map.Entry<Set<String>, Set<String>> regions = regionInfoEntry.getValue();
                message.append("\n" + pkg.getName() + " is exported in regions " + regions.getKey() + " but it is imported in regions " + regions.getValue());
            }
            ctx.reportError(message.toString());
            errorReported = true;
        }
        if (errorReported && ctx.getFeature().isComplete()) {
            ctx.reportError(ctx.getFeature().getId().toMvnId() + " is marked as 'complete' but has missing imports.");
        }
    }

    private Set<String> getBundleRegions(BundleDescriptor info, Map<String, Set<String>> bundleToOriginalFeatures, Map<String, Set<String>> featureToOriginalRegions) {
        HashSet<String> result = new HashSet<String>();
        Set<String> originFeatures = bundleToOriginalFeatures.get(info.getArtifact().getId().toMvnId());
        if (originFeatures != null) {
            for (String feature : originFeatures) {
                Set<String> originRegions = featureToOriginalRegions.get(feature);
                if (originRegions == null) continue;
                result.addAll(originRegions);
            }
        }
        if (result.size() == 0) {
            result.add(NO_REGION);
        }
        return result;
    }

    private ApiRegions readAPIRegionsFromFeature(AnalyserTaskContext ctx) {
        Feature feature = ctx.getFeature();
        Extension apiRegionsExtension = feature.getExtensions().getByName(API_REGIONS);
        if (apiRegionsExtension == null) {
            return null;
        }
        String apiRegionsJSON = apiRegionsExtension.getJSON();
        if (apiRegionsJSON != null && !apiRegionsJSON.isEmpty()) {
            return ApiRegions.fromJson(apiRegionsJSON);
        }
        return null;
    }

    private String getPackageInfo(List<PackageInfo> pcks, boolean includeVersion) {
        if (pcks.size() == 1) {
            if (includeVersion) {
                return pcks.get(0).toString();
            }
            return pcks.get(0).getName();
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append('[');
        for (PackageInfo info : pcks) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            if (includeVersion) {
                sb.append(info.toString());
                continue;
            }
            sb.append(info.getName());
        }
        sb.append(']');
        return sb.toString();
    }

    private Map<BundleDescriptor, Set<String>> getCandidates(List<BundleDescriptor> exportingBundles, PackageInfo pck, BundleDescriptor requestingBundle, Map<String, Set<String>> bundleToOriginalFeatures, Map<String, Set<String>> featureToOriginalRegions, ApiRegions apiRegions) throws IOException {
        Set<String> rf = bundleToOriginalFeatures.get(requestingBundle.getArtifact().getId().toMvnId());
        if (rf == null) {
            rf = Collections.emptySet();
        }
        Set<String> requestingFeatures = rf;
        HashMap<BundleDescriptor, Set<String>> candidates = new HashMap<BundleDescriptor, Set<String>>();
        for (BundleDescriptor info : exportingBundles) {
            Set intersection;
            if (!info.isExportingPackage(pck.getName())) continue;
            Set<String> providingFeatures = bundleToOriginalFeatures.get(info.getArtifact().getId().toMvnId());
            if (providingFeatures == null) {
                providingFeatures = Collections.emptySet();
            }
            if (!(intersection = providingFeatures.stream().filter(s -> requestingFeatures.contains(s)).collect(Collectors.toSet())).isEmpty()) {
                candidates.put(info, Collections.singleton(OWN_FEATURE));
                continue;
            }
            for (String region : this.getBundleRegions(info, bundleToOriginalFeatures, featureToOriginalRegions)) {
                if (!NO_REGION.equals(region) && !apiRegions.getApis(region).contains(pck.getName())) continue;
                HashSet<String> regions = (HashSet<String>)candidates.get(info);
                if (regions == null) {
                    regions = new HashSet<String>();
                    candidates.put(info, regions);
                }
                regions.add(region);
            }
        }
        return candidates;
    }

    private Map<String, Set<String>> readBundleOrigins(AnalyserTaskContext ctx) throws IOException {
        return this.readOrigins(ctx, "bundleOrigins.properties");
    }

    private Map<String, Set<String>> readRegionOrigins(AnalyserTaskContext ctx) throws IOException {
        return this.readOrigins(ctx, "regionOrigins.properties");
    }

    private Map<String, Set<String>> readOrigins(AnalyserTaskContext ctx, String fileName) throws IOException, FileNotFoundException {
        Feature feature = ctx.getFeature();
        Extension APIRegionExtension = feature.getExtensions().getByName(API_REGIONS);
        String fileStorage = ctx.getConfiguration().get(FILE_STORAGE_CONFIG_KEY);
        if (fileStorage == null) {
            if (APIRegionExtension != null) {
                throw new IllegalStateException("Feature " + feature.getId() + " has API regions defined, but no storage is configured for origin information files. Please configure the " + FILE_STORAGE_CONFIG_KEY + " configuration item.");
            }
            return Collections.emptyMap();
        }
        String featureName = feature.getId().toMvnId().replaceAll("[^a-zA-Z0-9\\.\\-]", "_");
        File file = new File(fileStorage, featureName + File.separator + fileName);
        if (!file.exists()) {
            if (APIRegionExtension != null) {
                throw new IllegalStateException("Feature " + feature.getId() + " has API regions defined but no file with origin information can be found " + file + " Configure the org.apache.sling.feature.extension.apiregions appropriately to write this information");
            }
            return Collections.emptyMap();
        }
        Properties p = new Properties();
        FileInputStream is = new FileInputStream(file);
        Object object = null;
        try {
            p.load(is);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (object != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ((InputStream)is).close();
                }
            }
        }
        HashMap<String, Set<String>> m = new HashMap<String, Set<String>>();
        for (String key : p.stringPropertyNames()) {
            String val = p.getProperty(key);
            String[] features = val.split(",");
            m.put(key, new HashSet<String>(Arrays.asList(features)));
        }
        return m;
    }

    public static final class Report {
        public List<PackageInfo> exportWithoutVersion = new ArrayList<PackageInfo>();
        public List<PackageInfo> exportMatchingSeveral = new ArrayList<PackageInfo>();
        public List<PackageInfo> importWithoutVersion = new ArrayList<PackageInfo>();
        public List<PackageInfo> missingExports = new ArrayList<PackageInfo>();
        public List<PackageInfo> missingExportsWithVersion = new ArrayList<PackageInfo>();
        public List<PackageInfo> missingExportsForOptional = new ArrayList<PackageInfo>();
        public Map<PackageInfo, Map.Entry<Set<String>, Set<String>>> regionInfo = new HashMap<PackageInfo, Map.Entry<Set<String>, Set<String>>>();
    }
}

