/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.stream.JsonParser;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.Extensions;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;

public class CheckApiRegionsOrder
implements AnalyserTask {
    protected static final String API_REGIONS_KEY = "api-regions";

    @Override
    public String getId() {
        return "api-regions-check-order";
    }

    @Override
    public String getName() {
        return "Api Regions check order analyser task";
    }

    @Override
    public final void execute(AnalyserTaskContext ctx) throws Exception {
        String order = ctx.getConfiguration().get("order");
        Feature feature = ctx.getFeature();
        if (feature == null) {
            this.reportError(ctx, "No feature found. Illegal Analyser State.");
            return;
        }
        if (order == null) {
            this.reportError(ctx, "This analyser task must be configured: " + this.getId() + " for feature " + feature.getId());
            this.reportError(ctx, "Must specify configuration key 'order'.");
            return;
        }
        String[] sl = order.split("[,]");
        ArrayList<String> prescribedOrder = new ArrayList<String>();
        for (String s : sl) {
            if ((s = s.trim()).length() <= 0) continue;
            prescribedOrder.add(s);
        }
        if (prescribedOrder.size() == 0) {
            this.reportError(ctx, "No regions declared in the 'order' configuration");
            return;
        }
        Extensions extensions = feature.getExtensions();
        Extension apiRegionsExtension = extensions.getByName(API_REGIONS_KEY);
        if (apiRegionsExtension == null) {
            return;
        }
        String jsonRepresentation = apiRegionsExtension.getJSON();
        if (jsonRepresentation == null || jsonRepresentation.isEmpty()) {
            return;
        }
        int regionIdx = 0;
        JsonParser parser = Json.createParser((Reader)new StringReader(jsonRepresentation));
        while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            if (JsonParser.Event.KEY_NAME != event) continue;
            switch (parser.getString()) {
                case "name": {
                    parser.next();
                    String name = parser.getString();
                    if (!prescribedOrder.contains(name)) {
                        this.reportError(ctx, "Region found with undeclared name: " + name);
                        return;
                    }
                    int prevIdx = regionIdx;
                    if ((regionIdx = this.validateRegion(regionIdx, prescribedOrder, name)) >= 0) break;
                    this.reportError(ctx, "Region '" + name + "' appears in the wrong order. It appears after '" + (String)prescribedOrder.get(prevIdx) + "'. Order of regions should be " + prescribedOrder);
                    return;
                }
            }
        }
    }

    private int validateRegion(int regionIdx, List<String> order, String name) {
        for (int i = regionIdx; i < order.size(); ++i) {
            if (!name.equals(order.get(i))) continue;
            return i;
        }
        return -1;
    }

    private String getPrefix() {
        return this.getId() + ": ";
    }

    private void reportError(AnalyserTaskContext ctx, String err) {
        ctx.reportError(this.getPrefix() + err);
    }
}

