/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionState;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.MatchingRequirement;
import org.apache.sling.feature.Prototype;
import org.apache.sling.feature.builder.BuilderContext;
import org.apache.sling.feature.builder.BuilderUtil;
import org.apache.sling.feature.builder.FeatureProvider;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;

public abstract class FeatureBuilder {
    private static final String TRACKING_KEY = "tracking-key";
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{[a-zA-Z0-9.\\-_]+\\}");

    public static Feature assemble(Feature feature, BuilderContext context) {
        if (feature == null || context == null) {
            throw new IllegalArgumentException("Feature and/or context must not be null");
        }
        return FeatureBuilder.internalAssemble(new ArrayList<String>(), feature, context);
    }

    public static Feature[] resolve(BuilderContext context, String ... featureIds) {
        if (featureIds == null || context == null) {
            throw new IllegalArgumentException("Features and/or context must not be null");
        }
        Feature[] features = new Feature[featureIds.length];
        int index = 0;
        for (String id : featureIds) {
            features[index] = context.getFeatureProvider().provide(ArtifactId.parse(id));
            if (features[index] == null) {
                throw new IllegalStateException("Unable to find prototype feature " + id);
            }
            ++index;
        }
        return features;
    }

    public static Feature[] deduplicate(final BuilderContext context, final Feature ... features) {
        if (features == null || context == null) {
            throw new IllegalArgumentException("Features and/or context must not be null");
        }
        ArrayList<Feature> featureList = new ArrayList<Feature>();
        for (Feature f : features) {
            Feature found = null;
            for (Feature s : featureList) {
                if (!s.getId().isSame(f.getId())) continue;
                found = s;
                break;
            }
            boolean add = true;
            if (found != null) {
                if (f.getId().getOSGiVersion().compareTo(found.getId().getOSGiVersion()) <= 0) {
                    add = false;
                } else {
                    featureList.remove(found);
                }
            }
            if (!add) continue;
            featureList.add(f);
        }
        ArrayList<Feature> assembledFeatures = new ArrayList<Feature>();
        final HashSet included = new HashSet();
        for (Feature f : featureList) {
            Feature assembled = FeatureBuilder.assemble(f, context.clone(new FeatureProvider(){

                @Override
                public Feature provide(ArtifactId id) {
                    included.add(id);
                    for (Feature f : features) {
                        if (!f.getId().equals(id)) continue;
                        return f;
                    }
                    return context.getFeatureProvider().provide(id);
                }
            }));
            assembledFeatures.add(assembled);
        }
        Iterator iter = assembledFeatures.iterator();
        while (iter.hasNext()) {
            Feature f;
            f = (Feature)iter.next();
            if (!included.contains(f.getId())) continue;
            iter.remove();
        }
        return assembledFeatures.toArray(new Feature[assembledFeatures.size()]);
    }

    public static Feature assemble(ArtifactId featureId, BuilderContext context, Feature ... features) {
        if (featureId == null || features == null || context == null) {
            throw new IllegalArgumentException("Features and/or context must not be null");
        }
        Feature target = new Feature(featureId);
        Feature[] assembledFeatures = FeatureBuilder.deduplicate(context, features);
        Extension list = new Extension(ExtensionType.ARTIFACTS, "assembled-features", ExtensionState.TRANSIENT);
        for (Feature feature : assembledFeatures) {
            list.getArtifacts().add(new Artifact(feature.getId()));
        }
        target.getExtensions().add(list);
        boolean targetIsComplete = true;
        boolean firstMerge = true;
        for (Feature assembled : assembledFeatures) {
            if (!assembled.isComplete()) {
                targetIsComplete = false;
            }
            FeatureBuilder.merge(target, assembled, context, context.getArtifactOverrides(), context.getConfigOverrides(), null, false, firstMerge);
            firstMerge = false;
        }
        if (targetIsComplete) {
            target.setComplete(true);
        }
        target.setAssembled(true);
        return target;
    }

    public static void resolveVariables(Feature feature, Map<String, String> additionalVariables) {
        for (Configuration configuration : feature.getConfigurations()) {
            HashSet<String> keys = new HashSet<String>(Collections.list(configuration.getProperties().keys()));
            for (String key : keys) {
                Object value = configuration.getProperties().get(key);
                if (value instanceof String) {
                    configuration.getProperties().put(key, FeatureBuilder.replaceVariables((String)value, additionalVariables, feature));
                    continue;
                }
                if (!(value instanceof String[])) continue;
                String[] values = (String[])value;
                for (int i = 0; i < values.length; ++i) {
                    values[i] = FeatureBuilder.replaceVariables(values[i], additionalVariables, feature);
                }
                configuration.getProperties().put(key, values);
            }
        }
        for (Map.Entry entry : feature.getFrameworkProperties().entrySet()) {
            entry.setValue(FeatureBuilder.replaceVariables((String)entry.getValue(), additionalVariables, feature));
        }
    }

    static String replaceVariables(String value, Map<String, String> additionalVariables, Feature feature) {
        String textWithVars = value;
        Matcher m = VARIABLE_PATTERN.matcher(textWithVars.toString());
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String var = m.group();
            int len = var.length();
            String name = var.substring(2, len - 1);
            if (!feature.getVariables().containsKey(name)) continue;
            String val = null;
            if (additionalVariables != null) {
                val = additionalVariables.get(name);
            }
            if (val == null) {
                val = feature.getVariables().get(name);
            }
            if (val != null) {
                String replaced = FeatureBuilder.replaceVariables(val, additionalVariables, feature);
                m.appendReplacement(sb, Matcher.quoteReplacement(replaced));
                continue;
            }
            throw new IllegalStateException("Undefined variable: " + name);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static Feature internalAssemble(List<String> processedFeatures, Feature feature, BuilderContext context) {
        if (feature.isAssembled()) {
            return feature;
        }
        if (processedFeatures.contains(feature.getId().toMvnId())) {
            throw new IllegalStateException("Recursive inclusion of " + feature.getId().toMvnId() + " via " + processedFeatures);
        }
        processedFeatures.add(feature.getId().toMvnId());
        Feature result = feature.copy();
        if (result.getPrototype() != null) {
            result.getVariables().clear();
            result.getBundles().clear();
            result.getFrameworkProperties().clear();
            result.getConfigurations().clear();
            result.getRequirements().clear();
            result.getCapabilities().clear();
            result.setPrototype(null);
            result.getExtensions().clear();
            Prototype i = feature.getPrototype();
            Feature f = context.getFeatureProvider().provide(i.getId());
            if (f == null) {
                throw new IllegalStateException("Unable to find prototype feature " + i.getId());
            }
            if (f.isFinal()) {
                throw new IllegalStateException("Prototype feature " + i.getId() + " is marked as final and can't be used in a prototype.");
            }
            Feature prototypeFeature = FeatureBuilder.internalAssemble(processedFeatures, f, context);
            FeatureBuilder.processPrototype(prototypeFeature, i);
            FeatureBuilder.merge(result, prototypeFeature, context, Collections.emptyList(), Collections.emptyMap(), TRACKING_KEY, true, true);
            FeatureBuilder.merge(result, feature, context, Collections.singletonList(ArtifactId.parse("*:*:ALL")), Collections.singletonMap("*", "MERGE_LATEST"), TRACKING_KEY, true, false);
            for (Artifact a : result.getBundles()) {
                a.getMetadata().remove(TRACKING_KEY);
                LinkedHashSet<ArtifactId> originList = new LinkedHashSet<ArtifactId>(Arrays.asList(a.getFeatureOrigins()));
                originList.remove(prototypeFeature.getId());
                originList.add(feature.getId());
                a.setFeatureOrigins(originList.toArray(new ArtifactId[0]));
            }
            for (Extension e : result.getExtensions()) {
                if (ExtensionType.ARTIFACTS != e.getType()) continue;
                for (Artifact a : e.getArtifacts()) {
                    a.getMetadata().remove(TRACKING_KEY);
                }
            }
            for (Configuration cfg : result.getConfigurations()) {
                List<ArtifactId> origins = cfg.getFeatureOrigins();
                if (origins.size() != 1 || !origins.contains(feature.getId())) continue;
                cfg.setFeatureOrigins(null);
            }
        }
        result.setAssembled(true);
        processedFeatures.remove(feature.getId().toMvnId());
        return result;
    }

    private static void merge(Feature target, Feature source, BuilderContext context, List<ArtifactId> artifactOverrides, Map<String, String> configOverrides, String originKey, boolean prototypeMerge, boolean initialMerge) {
        BuilderUtil.mergeVariables(target.getVariables(), source.getVariables(), context);
        BuilderUtil.mergeArtifacts(target.getBundles(), source.getBundles(), source, artifactOverrides, originKey);
        BuilderUtil.mergeConfigurations(target.getConfigurations(), source.getConfigurations(), configOverrides, source.getId());
        BuilderUtil.mergeFrameworkProperties(target.getFrameworkProperties(), source.getFrameworkProperties(), context);
        BuilderUtil.mergeRequirements(target.getRequirements(), source.getRequirements());
        BuilderUtil.mergeCapabilities(target.getCapabilities(), source.getCapabilities());
        BuilderUtil.mergeExtensions(target, source, context, artifactOverrides, originKey, prototypeMerge, initialMerge);
    }

    private static void processPrototype(Feature feature, Prototype prototype) {
        for (ArtifactId artifactId : prototype.getBundleRemovals()) {
            boolean removed = false;
            boolean ignoreVersion = artifactId.getOSGiVersion().equals((Object)Version.emptyVersion);
            if (ignoreVersion) {
                while (feature.getBundles().removeSame(artifactId)) {
                    removed = true;
                }
            } else {
                removed = feature.getBundles().removeExact(artifactId);
            }
            if (!removed) {
                throw new IllegalStateException("Bundle " + artifactId + " can't be removed from feature " + feature.getId() + " as it is not part of that feature.");
            }
            Iterator iter = feature.getConfigurations().iterator();
            while (iter.hasNext()) {
                Configuration cfg = (Configuration)iter.next();
                String bundleId = (String)cfg.getProperties().get(":configurator:feature:service.bundleLocation");
                if (bundleId == null) continue;
                ArtifactId bundleArtifactId = ArtifactId.fromMvnId(bundleId);
                boolean remove = false;
                remove = ignoreVersion ? bundleArtifactId.isSame(artifactId) : bundleArtifactId.equals(artifactId);
                if (!remove) continue;
                iter.remove();
            }
        }
        for (String string : prototype.getConfigurationRemovals()) {
            String attr;
            int attrPos = string.indexOf(64);
            String pid = attrPos == -1 ? string : string.substring(0, attrPos);
            String string2 = attr = attrPos == -1 ? null : string.substring(attrPos + 1);
            Configuration found = feature.getConfigurations().getConfiguration(pid);
            if (found == null) continue;
            if (attr == null) {
                feature.getConfigurations().remove(found);
                continue;
            }
            found.getProperties().remove(attr);
        }
        for (String string : prototype.getFrameworkPropertiesRemovals()) {
            feature.getFrameworkProperties().remove(string);
        }
        block5: for (String string : prototype.getExtensionRemovals()) {
            for (Extension ext : feature.getExtensions()) {
                if (!ext.getName().equals(string)) continue;
                feature.getExtensions().remove(ext);
                continue block5;
            }
        }
        block7: for (Map.Entry entry : prototype.getArtifactExtensionRemovals().entrySet()) {
            for (Extension ext : feature.getExtensions()) {
                if (!ext.getName().equals(entry.getKey())) continue;
                for (ArtifactId toRemove : (List)entry.getValue()) {
                    boolean removed = false;
                    boolean ignoreVersion = toRemove.getOSGiVersion().equals((Object)Version.emptyVersion);
                    Iterator iter = ext.getArtifacts().iterator();
                    while (iter.hasNext()) {
                        Artifact a = (Artifact)iter.next();
                        boolean remove = false;
                        if (ignoreVersion) {
                            if (a.getId().isSame(toRemove)) {
                                remove = true;
                            }
                        } else {
                            remove = a.getId().equals(toRemove);
                        }
                        if (remove) {
                            iter.remove();
                            removed = true;
                        }
                        if (!remove || ignoreVersion) continue;
                        break;
                    }
                    if (removed) continue;
                    throw new IllegalStateException("Artifact " + toRemove + " can't be removed from feature " + feature.getId() + " as it is not part of that feature.");
                }
                continue block7;
            }
        }
        for (MatchingRequirement matchingRequirement : prototype.getRequirementRemovals()) {
            feature.getRequirements().remove(matchingRequirement);
        }
        for (Capability capability : prototype.getCapabilityRemovals()) {
            feature.getCapabilities().remove(capability);
        }
    }
}

