/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature;

import java.util.ArrayList;
import java.util.Arrays;
import org.osgi.framework.Version;

public class ArtifactId
implements Comparable<ArtifactId> {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String classifier;
    private final String type;

    public ArtifactId(String groupId, String artifactId, String version, String classifier, String type) {
        if (groupId == null || artifactId == null || version == null) {
            throw new IllegalArgumentException("Argument must not be null");
        }
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = "bundle".equals(type) || type == null || type.isEmpty() ? "jar" : type;
        this.classifier = classifier != null && classifier.isEmpty() ? null : classifier;
    }

    public static ArtifactId parse(String s) {
        if (s.contains(":")) {
            return ArtifactId.fromMvnId(s);
        }
        if (s.contains("/")) {
            return ArtifactId.fromMvnUrl(s);
        }
        throw new IllegalArgumentException("Unable to parse mvn coordinates/url: " + s);
    }

    public static ArtifactId fromMvnUrl(String url) {
        if (url == null || url.indexOf(58) != -1 && !url.startsWith("mvn:")) {
            throw new IllegalArgumentException("Invalid mvn url: " + url);
        }
        if (url.indexOf(33) != -1) {
            throw new IllegalArgumentException("Repository url is not supported for Maven artifacts at the moment.");
        }
        String coordinates = url.startsWith("mvn:") ? url.substring(4) : url;
        String gId = null;
        String aId = null;
        String version = null;
        String type = null;
        String classifier = null;
        int part = 0;
        String value = coordinates;
        while (value != null) {
            String current;
            int pos = value.indexOf(47);
            if (pos == -1) {
                current = value;
                value = null;
            } else {
                current = pos == 0 ? null : value.substring(0, pos);
                value = value.substring(pos + 1);
            }
            if (current != null) {
                if (part == 0) {
                    gId = current;
                } else if (part == 1) {
                    aId = current;
                } else if (part == 2) {
                    version = current;
                } else if (part == 3) {
                    type = current;
                } else if (part == 4) {
                    classifier = current;
                }
            }
            ++part;
        }
        return new ArtifactId(gId, aId, version, classifier, type);
    }

    public static ArtifactId fromMvnId(String coordinates) {
        String[] parts = coordinates.split(":");
        if (parts.length < 3 || parts.length > 5) {
            throw new IllegalArgumentException("Invalid mvn coordinates: " + coordinates);
        }
        String gId = parts[0];
        String aId = parts[1];
        String version = parts[parts.length - 1];
        String type = parts.length > 3 ? parts[2] : null;
        String classifier = parts.length > 4 ? parts[3] : null;
        return new ArtifactId(gId, aId, version, classifier, type);
    }

    public String toMvnUrl() {
        StringBuilder sb = new StringBuilder("mvn:");
        sb.append(this.groupId);
        sb.append('/');
        sb.append(this.artifactId);
        sb.append('/');
        sb.append(this.version);
        if (this.classifier != null || !"jar".equals(this.type)) {
            sb.append('/');
            sb.append(this.type);
            if (this.classifier != null) {
                sb.append('/');
                sb.append(this.classifier);
            }
        }
        return sb.toString();
    }

    public String toMvnId() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupId);
        sb.append(':');
        sb.append(this.artifactId);
        if (this.classifier != null || !"jar".equals(this.type)) {
            sb.append(':');
            sb.append(this.type);
            if (this.classifier != null) {
                sb.append(':');
                sb.append(this.classifier);
            }
        }
        sb.append(':');
        sb.append(this.version);
        return sb.toString();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isSame(ArtifactId id) {
        if (this.groupId.equals(id.groupId) && this.artifactId.equals(id.artifactId) && this.type.equals(id.type)) {
            if (this.classifier == null && id.classifier == null) {
                return true;
            }
            if (this.classifier != null) {
                return this.classifier.equals(id.classifier);
            }
        }
        return false;
    }

    public Version getOSGiVersion() {
        int pos;
        String[] parts = this.version.split("\\.");
        if (parts.length < 4) {
            pos = parts[parts.length - 1].indexOf(45);
            if (pos != -1) {
                String[] newParts = new String[4];
                String string = newParts[0] = parts.length > 1 ? parts[0] : parts[0].substring(0, pos);
                String string2 = parts.length > 2 ? parts[1] : (newParts[1] = parts.length > 1 ? parts[1].substring(0, pos) : "0");
                newParts[2] = parts.length > 3 ? parts[2] : (parts.length > 2 ? parts[2].substring(0, pos) : "0");
                newParts[3] = parts[parts.length - 1].substring(pos + 1);
                parts = newParts;
            } else {
                for (int i = 0; i < parts.length; ++i) {
                    pos = parts[i].indexOf(95);
                    while (pos != -1 && pos < parts[i].length() - 1) {
                        ArrayList<String> newParts = new ArrayList<String>(Arrays.asList(parts));
                        newParts.remove(i);
                        newParts.add(i, parts[i].substring(0, pos));
                        newParts.add(i + 1, parts[i].substring(pos + 1));
                        parts = newParts.toArray(new String[0]);
                        pos = parts[i].indexOf(95);
                    }
                }
            }
        }
        if (parts.length >= 4 && (pos = parts[2].indexOf(45)) != -1) {
            parts[3] = parts[2].substring(pos + 1) + "." + parts[3];
            parts[2] = parts[2].substring(0, pos);
        }
        if (parts.length > 4) {
            StringBuilder sb = new StringBuilder(parts[3]);
            for (int i = 4; i < parts.length; ++i) {
                sb.append('.');
                sb.append(parts[i]);
            }
            parts[3] = sb.toString();
        }
        if (parts.length > 3 && parts[3] != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < parts[3].length(); ++i) {
                char c = parts[3].charAt(i);
                if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '-') {
                    sb.append(c);
                    continue;
                }
                sb.append('_');
            }
            parts[3] = sb.toString();
        }
        int majorVersion = ArtifactId.parseInt(parts[0], this.version);
        int minorVersion = parts.length > 1 ? ArtifactId.parseInt(parts[1], this.version) : 0;
        int microVersion = parts.length > 2 ? ArtifactId.parseInt(parts[2], this.version) : 0;
        String qualifier = parts.length > 3 ? parts[3] : "";
        return new Version(majorVersion, minorVersion, microVersion, qualifier);
    }

    public String toMvnPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupId.replace('.', '/'));
        sb.append('/');
        sb.append(this.artifactId);
        sb.append('/');
        sb.append(this.version);
        sb.append('/');
        sb.append(this.artifactId);
        sb.append('-');
        sb.append(this.version);
        if (this.classifier != null) {
            sb.append('-');
            sb.append(this.classifier);
        }
        sb.append('.');
        sb.append(this.type);
        return sb.toString();
    }

    public int hashCode() {
        return this.toMvnUrl().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ArtifactId)) {
            return false;
        }
        return this.toMvnUrl().equals(((ArtifactId)o).toMvnUrl());
    }

    @Override
    public int compareTo(ArtifactId o) {
        if (o == null) {
            return 1;
        }
        return this.toMvnUrl().compareTo(o.toMvnUrl());
    }

    public String toString() {
        return this.toMvnId();
    }

    private static int parseInt(String value, String version) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid version " + version);
        }
    }
}

