/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.builder;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Artifacts;
import org.apache.sling.feature.Bundles;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Configurations;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.builder.BuilderContext;
import org.apache.sling.feature.builder.HandlerContext;
import org.apache.sling.feature.builder.MergeHandler;
import org.apache.sling.feature.builder.PostProcessHandler;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

class BuilderUtil {
    static final String OVERRIDE_SELECT_ALL = "ALL";
    static final String OVERRIDE_SELECT_HIGHEST = "HIGHEST";
    static final String OVERRIDE_SELECT_LATEST = "LATEST";
    static final String CATCHALL_OVERRIDE = "*:*:";
    static final String ALL_HANDLERS_KEY = "all";

    BuilderUtil() {
    }

    static boolean contains(String key, Iterable<Map.Entry<String, String>> iterable) {
        if (iterable != null) {
            for (Map.Entry<String, String> entry : iterable) {
                if (!key.equals(entry.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    static String get(String key, Iterable<Map.Entry<String, String>> iterable) {
        if (iterable != null) {
            for (Map.Entry<String, String> entry : iterable) {
                if (!key.equals(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    private static void mergeWithContextOverride(String type, Map<String, String> target, Map<String, String> source, Iterable<Map.Entry<String, String>> context) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : target.entrySet()) {
            result.put(entry.getKey(), BuilderUtil.contains(entry.getKey(), context) ? BuilderUtil.get(entry.getKey(), context) : entry.getValue());
        }
        for (Map.Entry<String, String> entry : source.entrySet()) {
            if (BuilderUtil.contains(entry.getKey(), context)) {
                result.put(entry.getKey(), BuilderUtil.get(entry.getKey(), context));
                continue;
            }
            String value = source.get(entry.getKey());
            if (value != null) {
                String targetValue = target.get(entry.getKey());
                if (targetValue != null) {
                    if (value.equals(targetValue)) continue;
                    throw new IllegalStateException(String.format("Can't merge %s '%s' defined twice (as '%s' v.s. '%s') and not overridden.", type, entry.getKey(), value, targetValue));
                }
                result.put(entry.getKey(), value);
                continue;
            }
            if (BuilderUtil.contains(entry.getKey(), target.entrySet())) continue;
            result.put(entry.getKey(), value);
        }
        target.clear();
        target.putAll(result);
    }

    static void mergeVariables(Map<String, String> target, Map<String, String> source, BuilderContext context) {
        BuilderUtil.mergeWithContextOverride("Variable", target, source, null != context ? context.getVariablesOverrides().entrySet() : null);
    }

    static void mergeBundles(Bundles target, Bundles source, Feature sourceFeature, List<String> artifactOverrides, String originKey) {
        for (Map.Entry<Integer, List<Artifact>> entry : source.getBundlesByStartOrder().entrySet()) {
            for (Artifact a : entry.getValue()) {
                Set<ArtifactId> artifactIds = a.getAliases(true);
                ArrayList<Artifact> allExisting = new ArrayList<Artifact>();
                for (ArtifactId id : artifactIds) {
                    Artifact s = target.getSame(id);
                    if (s != null) {
                        allExisting.add(s);
                    }
                    allExisting.addAll(BuilderUtil.findAliasedArtifacts(id, target));
                }
                ArrayList<Artifact> selectedArtifacts = new ArrayList<Artifact>();
                for (Artifact existing : allExisting) {
                    if (sourceFeature.getId().toMvnId().equals(existing.getMetadata().get(originKey))) {
                        selectedArtifacts.addAll(Arrays.asList(existing, a));
                        continue;
                    }
                    selectedArtifacts.addAll(BuilderUtil.selectArtifactOverride(existing, a, artifactOverrides));
                    while (target.removeSame(existing.getId())) {
                    }
                }
                if (selectedArtifacts.isEmpty()) {
                    selectedArtifacts.add(a);
                }
                for (Artifact sa : selectedArtifacts) {
                    Artifact cp = sa.copy(sa.getId());
                    if (originKey != null && sourceFeature != null && source.contains(sa) && sa.getMetadata().get(originKey) == null) {
                        cp.getMetadata().put(originKey, sourceFeature.getId().toMvnId());
                    }
                    target.add(cp);
                }
            }
        }
    }

    static List<Artifact> selectArtifactOverride(Artifact a1, Artifact a2, List<String> artifactOverrides) {
        if (a1.getId().equals(a2.getId())) {
            return Collections.singletonList(a2);
        }
        Set<String> commonPrefixes = BuilderUtil.getCommonPrefixes(a1, a2);
        if (commonPrefixes.isEmpty()) {
            throw new IllegalStateException("Internal error selecting override. No common prefix between " + a1 + " and " + a2);
        }
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
        for (String prefix : commonPrefixes) {
            for (String o : artifactOverrides) {
                int idx;
                if (!o.startsWith(prefix) && !o.startsWith(CATCHALL_OVERRIDE) || (idx = o.lastIndexOf(58)) <= 0 || o.length() <= idx) continue;
                String rule = o.substring(idx + 1).trim();
                if (OVERRIDE_SELECT_ALL.equals(rule)) {
                    return Arrays.asList(a1, a2);
                }
                if (OVERRIDE_SELECT_HIGHEST.equals(rule)) {
                    Version a2v;
                    Version a1v = a1.getId().getOSGiVersion();
                    return a1v.compareTo(a2v = a2.getId().getOSGiVersion()) > 0 ? Collections.singletonList(a1) : Collections.singletonList(a2);
                }
                if (OVERRIDE_SELECT_LATEST.equals(rule)) {
                    return Collections.singletonList(a2);
                }
                if (a1.getId().getVersion().equals(rule)) {
                    result.add(a1);
                    continue;
                }
                if (a2.getId().getVersion().equals(rule)) {
                    result.add(a2);
                    continue;
                }
                result.add(new Artifact(ArtifactId.fromMvnId(o)));
            }
        }
        if (result.size() > 0) {
            return new ArrayList<Artifact>(result);
        }
        throw new IllegalStateException("Artifact override rule required to select between these two artifacts " + a1 + " and " + a2 + ". The rule must be specified for " + commonPrefixes);
    }

    private static Set<String> getCommonPrefixes(Artifact a1, Artifact a2) {
        Set<String> a1Prefixes = BuilderUtil.getPrefixesIncludingAliases(a1);
        Set<String> a2Prefixes = BuilderUtil.getPrefixesIncludingAliases(a2);
        a1Prefixes.retainAll(a2Prefixes);
        return a1Prefixes;
    }

    private static Set<String> getPrefixesIncludingAliases(Artifact a) {
        HashSet<String> prefixes = new HashSet<String>();
        for (ArtifactId aid : a.getAliases(true)) {
            String id = aid.toMvnId();
            prefixes.add(id.substring(0, id.lastIndexOf(58) + 1));
        }
        return prefixes;
    }

    private static List<Artifact> findAliasedArtifacts(ArtifactId id, Artifacts bundles) {
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        String prefix = id.getGroupId() + ":" + id.getArtifactId() + ":";
        for (Artifact a : bundles) {
            for (ArtifactId aid : a.getAliases(false)) {
                if (!aid.toMvnId().startsWith(prefix)) continue;
                result.add(a);
            }
        }
        return result;
    }

    static void mergeConfigurations(Configurations target, Configurations source) {
        for (Configuration cfg : source) {
            boolean found = false;
            for (Configuration current : target) {
                if (current.compareTo(cfg) != 0) continue;
                found = true;
                Enumeration<String> i = cfg.getProperties().keys();
                while (i.hasMoreElements()) {
                    String key = i.nextElement();
                    current.getProperties().put(key, cfg.getProperties().get(key));
                }
                break block1;
            }
            if (found) continue;
            Configuration newCfg = cfg.copy(cfg.getPid());
            target.add(newCfg);
        }
    }

    static void mergeFrameworkProperties(Map<String, String> target, Map<String, String> source, BuilderContext context) {
        BuilderUtil.mergeWithContextOverride("Property", target, source, context != null ? context.getFrameworkPropertiesOverrides().entrySet() : null);
    }

    static void mergeRequirements(List<Requirement> target, List<Requirement> source) {
        for (Requirement req : source) {
            if (target.contains(req)) continue;
            target.add(req);
        }
    }

    static void mergeCapabilities(List<Capability> target, List<Capability> source) {
        for (Capability cap : source) {
            if (target.contains(cap)) continue;
            target.add(cap);
        }
    }

    static void mergeExtensions(Extension target, Extension source, Feature sourceFeature, List<String> artifactOverrides, String originKey) {
        switch (target.getType()) {
            case TEXT: {
                target.setText(target.getText() + "\n" + source.getText());
                break;
            }
            case JSON: {
                JsonStructure struct2;
                JsonStructure struct1;
                try (StringReader reader = new StringReader(target.getJSON());){
                    struct1 = Json.createReader((Reader)reader).read();
                }
                try (StringReader reader = new StringReader(source.getJSON());){
                    struct2 = Json.createReader((Reader)reader).read();
                }
                if (struct1.getValueType() != struct2.getValueType()) {
                    throw new IllegalStateException("Found different JSON types for extension " + target.getName() + " : " + struct1.getValueType() + " and " + struct2.getValueType());
                }
                if (struct1.getValueType() == JsonValue.ValueType.ARRAY) {
                    JsonArrayBuilder builder = Json.createArrayBuilder();
                    Stream.concat(((JsonArray)struct1).stream(), ((JsonArray)struct2).stream()).forEachOrdered(arg_0 -> ((JsonArrayBuilder)builder).add(arg_0));
                    struct1 = builder.build();
                } else {
                    struct1 = BuilderUtil.merge((JsonObject)struct1, (JsonObject)struct2);
                }
                StringWriter buffer = new StringWriter();
                try (JsonWriter writer = Json.createWriter((Writer)buffer);){
                    writer.write(struct1);
                }
                target.setJSON(buffer.toString());
                break;
            }
            case ARTIFACTS: {
                for (Artifact a : source.getArtifacts()) {
                    Set<ArtifactId> artifactIds = a.getAliases(true);
                    ArrayList<Artifact> allExisting = new ArrayList<Artifact>();
                    for (ArtifactId id : artifactIds) {
                        Artifact s = target.getArtifacts().getSame(id);
                        if (s != null) {
                            allExisting.add(s);
                        }
                        allExisting.addAll(BuilderUtil.findAliasedArtifacts(id, target.getArtifacts()));
                    }
                    ArrayList<Artifact> selectedArtifacts = new ArrayList<Artifact>();
                    for (Artifact existing : allExisting) {
                        if (sourceFeature.getId().toMvnId().equals(existing.getMetadata().get(originKey))) {
                            selectedArtifacts.addAll(Arrays.asList(existing, a));
                            continue;
                        }
                        selectedArtifacts.addAll(BuilderUtil.selectArtifactOverride(existing, a, artifactOverrides));
                        while (target.getArtifacts().removeSame(existing.getId())) {
                        }
                    }
                    if (selectedArtifacts.isEmpty()) {
                        selectedArtifacts.add(a);
                    }
                    for (Artifact sa : selectedArtifacts) {
                        Artifact cp = sa.copy(sa.getId());
                        if (originKey != null && sourceFeature != null && source.getArtifacts().contains(sa) && sa.getMetadata().get(originKey) == null) {
                            cp.getMetadata().put(originKey, sourceFeature.getId().toMvnId());
                        }
                        target.getArtifacts().add(cp);
                    }
                }
                break;
            }
        }
    }

    static void mergeExtensions(Feature target, Feature source, BuilderContext context, List<String> artifactOverrides, String originKey) {
        for (Extension ext : source.getExtensions()) {
            boolean found = false;
            for (Extension current : new ArrayList<Extension>(target.getExtensions())) {
                if (!current.getName().equals(ext.getName())) continue;
                found = true;
                if (current.getType() != ext.getType()) {
                    throw new IllegalStateException("Found different types for extension " + current.getName() + " : " + (Object)((Object)current.getType()) + " and " + (Object)((Object)ext.getType()));
                }
                boolean handled = false;
                for (MergeHandler me : context.getMergeExtensions()) {
                    if (!me.canMerge(current)) continue;
                    me.merge(new HandlerContextImpl(context, me), target, source, current, ext);
                    handled = true;
                    break;
                }
                if (handled) continue;
                BuilderUtil.mergeExtensions(current, ext, source, artifactOverrides, originKey);
            }
            if (found) continue;
            boolean handled = false;
            for (MergeHandler mh : context.getMergeExtensions()) {
                if (!mh.canMerge(ext)) continue;
                mh.merge(new HandlerContextImpl(context, mh), target, source, null, ext);
                handled = true;
                break;
            }
            if (handled) continue;
            target.getExtensions().add(ext);
        }
        for (Extension ext : target.getExtensions()) {
            for (PostProcessHandler ppe : context.getPostProcessExtensions()) {
                ppe.postProcess(new HandlerContextImpl(context, ppe), target, ext);
            }
        }
    }

    private static JsonObject merge(JsonObject obj1, JsonObject obj2) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (Map.Entry entry : obj1.entrySet()) {
            builder.add((String)entry.getKey(), (JsonValue)entry.getValue());
        }
        for (Map.Entry entry : obj2.entrySet()) {
            if (!obj1.containsKey(entry.getKey())) {
                builder.add((String)entry.getKey(), (JsonValue)entry.getValue());
                continue;
            }
            JsonValue oldValue = (JsonValue)obj1.get(entry.getKey());
            if (oldValue.getValueType() != ((JsonValue)entry.getValue()).getValueType()) {
                builder.add((String)entry.getKey(), (JsonValue)entry.getValue());
                continue;
            }
            if (oldValue.getValueType() == JsonValue.ValueType.ARRAY) {
                JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
                Stream.concat(((JsonArray)oldValue).stream(), ((JsonArray)entry.getValue()).stream()).forEachOrdered(arg_0 -> ((JsonArrayBuilder)arrayBuilder).add(arg_0));
                builder.add((String)entry.getKey(), (JsonValue)arrayBuilder.build());
                continue;
            }
            if (oldValue.getValueType() == JsonValue.ValueType.OBJECT) {
                builder.add((String)entry.getKey(), (JsonValue)BuilderUtil.merge((JsonObject)oldValue, (JsonObject)entry.getValue()));
                continue;
            }
            builder.add((String)entry.getKey(), (JsonValue)entry.getValue());
        }
        return builder.build();
    }

    static class HandlerContextImpl
    implements HandlerContext {
        private final ArtifactProvider artifactProvider;
        private final Map<String, String> configuration;

        HandlerContextImpl(BuilderContext bc, MergeHandler handler) {
            this.artifactProvider = bc.getArtifactProvider();
            this.configuration = this.getHandlerConfiguration(bc, handler);
        }

        HandlerContextImpl(BuilderContext bc, PostProcessHandler handler) {
            this.artifactProvider = bc.getArtifactProvider();
            this.configuration = this.getHandlerConfiguration(bc, handler);
        }

        private Map<String, String> getHandlerConfiguration(BuilderContext bc, Object handler) {
            Map<String, String> handlerSpecific;
            String name;
            HashMap<String, String> result = new HashMap<String, String>();
            Map<String, String> overall = bc.getHandlerConfigurations().get(BuilderUtil.ALL_HANDLERS_KEY);
            if (overall != null) {
                result.putAll(overall);
            }
            if ((name = HandlerContextImpl.getHandlerName(handler)) != null && (handlerSpecific = bc.getHandlerConfigurations().get(name)) != null) {
                result.putAll(handlerSpecific);
            }
            return result;
        }

        private static String getHandlerName(Object handler) {
            return handler.getClass().getSimpleName();
        }

        @Override
        public ArtifactProvider getArtifactProvider() {
            return this.artifactProvider;
        }

        @Override
        public Map<String, String> getConfiguration() {
            return this.configuration;
        }
    }
}

