/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.builder.FeatureProvider;
import org.apache.sling.feature.builder.MergeHandler;
import org.apache.sling.feature.builder.PostProcessHandler;

public class BuilderContext {
    private final FeatureProvider provider;
    private ArtifactProvider artifactProvider;
    private final Map<String, Map<String, String>> extensionConfiguration = new HashMap<String, Map<String, String>>();
    private final List<MergeHandler> mergeExtensions = new ArrayList<MergeHandler>();
    private final List<PostProcessHandler> postProcessExtensions = new ArrayList<PostProcessHandler>();
    private final List<String> artifactsOverrides = new ArrayList<String>();
    private final Map<String, String> variables = new HashMap<String, String>();
    private final Map<String, String> frameworkProperties = new HashMap<String, String>();

    public BuilderContext(FeatureProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Provider must not be null");
        }
        this.provider = provider;
    }

    public BuilderContext setArtifactProvider(ArtifactProvider ap) {
        this.artifactProvider = ap;
        return this;
    }

    public BuilderContext addVariablesOverrides(Map<String, String> vars) {
        this.variables.putAll(vars);
        return this;
    }

    public BuilderContext addFrameworkPropertiesOverrides(Map<String, String> props) {
        this.frameworkProperties.putAll(props);
        return this;
    }

    public BuilderContext addArtifactsOverrides(List<String> overrides) {
        this.artifactsOverrides.addAll(overrides);
        return this;
    }

    public BuilderContext addMergeExtensions(MergeHandler ... extensions) {
        this.mergeExtensions.addAll(Arrays.asList(extensions));
        return this;
    }

    public BuilderContext addPostProcessExtensions(PostProcessHandler ... extensions) {
        this.postProcessExtensions.addAll(Arrays.asList(extensions));
        return this;
    }

    public BuilderContext setHandlerConfiguration(String name, Map<String, String> cfg) {
        this.extensionConfiguration.put(name, cfg);
        return this;
    }

    Map<String, Map<String, String>> getHandlerConfigurations() {
        return this.extensionConfiguration;
    }

    ArtifactProvider getArtifactProvider() {
        return this.artifactProvider;
    }

    List<String> getArtifactOverrides() {
        return this.artifactsOverrides;
    }

    Map<String, String> getVariablesOverrides() {
        return this.variables;
    }

    Map<String, String> getFrameworkPropertiesOverrides() {
        return this.frameworkProperties;
    }

    FeatureProvider getFeatureProvider() {
        return this.provider;
    }

    List<MergeHandler> getMergeExtensions() {
        return this.mergeExtensions;
    }

    List<PostProcessHandler> getPostProcessExtensions() {
        return this.postProcessExtensions;
    }

    BuilderContext clone(FeatureProvider featureProvider) {
        BuilderContext ctx = new BuilderContext(featureProvider);
        ctx.setArtifactProvider(this.artifactProvider);
        ctx.artifactsOverrides.addAll(this.artifactsOverrides);
        ctx.variables.putAll(this.variables);
        ctx.frameworkProperties.putAll(this.frameworkProperties);
        ctx.mergeExtensions.addAll(this.mergeExtensions);
        ctx.postProcessExtensions.addAll(this.postProcessExtensions);
        return ctx;
    }
}

