/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.builder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.Include;
import org.apache.sling.feature.builder.BuilderContext;
import org.apache.sling.feature.builder.BuilderUtil;
import org.apache.sling.feature.builder.FeatureProvider;

public class FeatureBuilder {
    public static Feature assemble(Feature feature, BuilderContext context) {
        if (feature == null || context == null) {
            throw new IllegalArgumentException("Feature and/or context must not be null");
        }
        return FeatureBuilder.internalAssemble(new ArrayList<String>(), feature, context);
    }

    public static Feature[] resolve(BuilderContext context, String ... featureIds) {
        if (featureIds == null || context == null) {
            throw new IllegalArgumentException("Features and/or context must not be null");
        }
        Feature[] features = new Feature[featureIds.length];
        int index = 0;
        for (String id : featureIds) {
            features[index] = context.getFeatureProvider().provide(ArtifactId.parse(id));
            if (features[index] == null) {
                throw new IllegalStateException("Unable to find included feature " + id);
            }
            ++index;
        }
        return features;
    }

    public static Feature[] deduplicate(final BuilderContext context, final Feature ... features) {
        if (features == null || context == null) {
            throw new IllegalArgumentException("Features and/or context must not be null");
        }
        ArrayList<Feature> featureList = new ArrayList<Feature>();
        for (Feature f : features) {
            Feature found = null;
            for (Feature s : featureList) {
                if (!s.getId().isSame(f.getId())) continue;
                found = s;
                break;
            }
            boolean add = true;
            if (found != null) {
                if (f.getId().getOSGiVersion().compareTo(found.getId().getOSGiVersion()) <= 0) {
                    add = false;
                } else {
                    featureList.remove(found);
                }
            }
            if (!add) continue;
            featureList.add(f);
        }
        ArrayList<Feature> assembledFeatures = new ArrayList<Feature>();
        final HashSet included = new HashSet();
        for (Feature f : featureList) {
            Feature assembled = FeatureBuilder.assemble(f, context.clone(new FeatureProvider(){

                @Override
                public Feature provide(ArtifactId id) {
                    included.add(id);
                    for (Feature f : features) {
                        if (!f.getId().equals(id)) continue;
                        return f;
                    }
                    return context.getFeatureProvider().provide(id);
                }
            }));
            assembledFeatures.add(assembled);
        }
        Iterator iter = assembledFeatures.iterator();
        while (iter.hasNext()) {
            Feature f;
            f = (Feature)iter.next();
            if (!included.contains(f.getId())) continue;
            iter.remove();
        }
        return assembledFeatures.toArray(new Feature[assembledFeatures.size()]);
    }

    private static Feature internalAssemble(List<String> processedFeatures, Feature feature, BuilderContext context) {
        if (feature.isAssembled()) {
            return feature;
        }
        if (processedFeatures.contains(feature.getId().toMvnId())) {
            throw new IllegalStateException("Recursive inclusion of " + feature.getId().toMvnId() + " via " + processedFeatures);
        }
        processedFeatures.add(feature.getId().toMvnId());
        Feature result = feature.copy();
        if (!result.getIncludes().isEmpty()) {
            ArrayList<Include> includes = new ArrayList<Include>(result.getIncludes());
            result.getBundles().clear();
            result.getFrameworkProperties().clear();
            result.getConfigurations().clear();
            result.getRequirements().clear();
            result.getCapabilities().clear();
            result.getIncludes().clear();
            result.getExtensions().clear();
            for (Include i : includes) {
                Feature f = context.getFeatureProvider().provide(i.getId());
                if (f == null) {
                    throw new IllegalStateException("Unable to find included feature " + i.getId());
                }
                Feature af = FeatureBuilder.internalAssemble(processedFeatures, f, context);
                FeatureBuilder.include(af, i);
                FeatureBuilder.merge(result, af, context);
            }
            FeatureBuilder.merge(result, feature, context);
        }
        processedFeatures.remove(feature.getId().toMvnId());
        result.setAssembled(true);
        return result;
    }

    private static void merge(Feature target, Feature source, BuilderContext context) {
        BuilderUtil.mergeBundles(target.getBundles(), source.getBundles(), BuilderUtil.ArtifactMerge.LATEST);
        BuilderUtil.mergeConfigurations(target.getConfigurations(), source.getConfigurations());
        BuilderUtil.mergeFrameworkProperties(target.getFrameworkProperties(), source.getFrameworkProperties());
        BuilderUtil.mergeRequirements(target.getRequirements(), source.getRequirements());
        BuilderUtil.mergeCapabilities(target.getCapabilities(), source.getCapabilities());
        BuilderUtil.mergeExtensions(target, source, BuilderUtil.ArtifactMerge.LATEST, context);
    }

    private static void include(Feature base, Include i) {
        for (ArtifactId artifactId : i.getBundleRemovals()) {
            base.getBundles().removeExact(artifactId);
            Iterator iter = base.getConfigurations().iterator();
            while (iter.hasNext()) {
                Configuration cfg = (Configuration)iter.next();
                String bundleId = (String)cfg.getProperties().get("service.bundleLocation");
                if (!artifactId.toMvnId().equals(bundleId)) continue;
                iter.remove();
            }
        }
        for (String string : i.getConfigurationRemovals()) {
            int attrPos = string.indexOf(64);
            String val = attrPos == -1 ? string : string.substring(0, attrPos);
            String attr = attrPos == -1 ? null : string.substring(attrPos + 1);
            int sepPos = val.indexOf(126);
            Configuration found = null;
            if (sepPos == -1) {
                found = base.getConfigurations().getConfiguration(val);
            } else {
                String factoryPid = val.substring(0, sepPos);
                String name = val.substring(sepPos + 1);
                found = base.getConfigurations().getFactoryConfiguration(factoryPid, name);
            }
            if (found == null) continue;
            if (attr == null) {
                base.getConfigurations().remove(found);
                continue;
            }
            found.getProperties().remove(attr);
        }
        for (String string : i.getFrameworkPropertiesRemovals()) {
            base.getFrameworkProperties().remove(string);
        }
        block4: for (String string : i.getExtensionRemovals()) {
            for (Extension ext : base.getExtensions()) {
                if (!ext.getName().equals(string)) continue;
                base.getExtensions().remove(ext);
                continue block4;
            }
        }
        block6: for (Map.Entry entry : i.getArtifactExtensionRemovals().entrySet()) {
            for (Extension ext : base.getExtensions()) {
                if (!ext.getName().equals(entry.getKey())) continue;
                block8: for (ArtifactId id : (List)entry.getValue()) {
                    for (Artifact a : ext.getArtifacts()) {
                        if (!a.getId().equals(id)) continue;
                        ext.getArtifacts().remove(a);
                        continue block8;
                    }
                }
                continue block6;
            }
        }
    }
}

