/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.builder;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import org.apache.sling.feature.Application;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.Bundles;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Configurations;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.KeyValueMap;
import org.apache.sling.feature.builder.BuilderContext;
import org.apache.sling.feature.builder.FeatureExtensionHandler;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

class BuilderUtil {
    BuilderUtil() {
    }

    static void mergeBundles(Bundles target, Bundles source, ArtifactMerge artifactMergeAlg) {
        for (Map.Entry<Integer, List<Artifact>> entry : source.getBundlesByStartOrder().entrySet()) {
            for (Artifact a : entry.getValue()) {
                Artifact existing;
                boolean replace = true;
                if (artifactMergeAlg == ArtifactMerge.HIGHEST && (existing = target.getSame(a.getId())) != null && existing.getId().getOSGiVersion().compareTo(a.getId().getOSGiVersion()) > 0) {
                    replace = false;
                }
                if (!replace) continue;
                target.removeSame(a.getId());
                target.add(a);
            }
        }
    }

    static void mergeConfigurations(Configurations target, Configurations source) {
        for (Configuration cfg : source) {
            boolean found = false;
            for (Configuration current : target) {
                if (current.compareTo(cfg) != 0) continue;
                found = true;
                Enumeration<String> i = cfg.getProperties().keys();
                while (i.hasMoreElements()) {
                    String key = i.nextElement();
                    current.getProperties().put(key, cfg.getProperties().get(key));
                }
                break block1;
            }
            if (found) continue;
            target.add(cfg);
        }
    }

    static void mergeFrameworkProperties(KeyValueMap target, KeyValueMap source) {
        target.putAll(source);
    }

    static void mergeRequirements(List<Requirement> target, List<Requirement> source) {
        for (Requirement req : source) {
            if (target.contains(req)) continue;
            target.add(req);
        }
    }

    static void mergeCapabilities(List<Capability> target, List<Capability> source) {
        for (Capability cap : source) {
            if (target.contains(cap)) continue;
            target.add(cap);
        }
    }

    static void mergeExtensions(Extension target, Extension source, ArtifactMerge artifactMergeAlg) {
        switch (target.getType()) {
            case TEXT: {
                target.setText(target.getText() + "\n" + source.getText());
                break;
            }
            case JSON: {
                JsonStructure struct2;
                JsonStructure struct1;
                try (StringReader reader = new StringReader(target.getJSON());){
                    struct1 = Json.createReader((Reader)reader).read();
                }
                try (StringReader reader = new StringReader(source.getJSON());){
                    struct2 = Json.createReader((Reader)reader).read();
                }
                if (struct1.getValueType() != struct2.getValueType()) {
                    throw new IllegalStateException("Found different JSON types for extension " + target.getName() + " : " + struct1.getValueType() + " and " + struct2.getValueType());
                }
                if (struct1.getValueType() == JsonValue.ValueType.ARRAY) {
                    JsonArrayBuilder builder = Json.createArrayBuilder();
                    Stream.concat(((JsonArray)struct1).stream(), ((JsonArray)struct2).stream()).forEachOrdered(arg_0 -> ((JsonArrayBuilder)builder).add(arg_0));
                    struct1 = builder.build();
                } else {
                    BuilderUtil.merge((JsonObject)struct1, (JsonObject)struct2);
                }
                StringWriter buffer = new StringWriter();
                try (JsonWriter writer = Json.createWriter((Writer)buffer);){
                    writer.write(struct1);
                }
                target.setJSON(buffer.toString());
                break;
            }
            case ARTIFACTS: {
                for (Artifact a : source.getArtifacts()) {
                    boolean add = true;
                    for (Artifact targetArtifact : target.getArtifacts()) {
                        if (!targetArtifact.getId().isSame(a.getId())) continue;
                        if (artifactMergeAlg == ArtifactMerge.HIGHEST) {
                            if (targetArtifact.getId().getOSGiVersion().compareTo(a.getId().getOSGiVersion()) > 0) {
                                add = false;
                                break;
                            }
                            target.getArtifacts().remove(targetArtifact);
                            break;
                        }
                        target.getArtifacts().remove(targetArtifact);
                        break;
                    }
                    if (!add) continue;
                    target.getArtifacts().add(a);
                }
                break;
            }
        }
    }

    static void mergeExtensions(Feature target, Feature source, ArtifactMerge artifactMergeAlg, BuilderContext context) {
        for (Extension ext : source.getExtensions()) {
            boolean found = false;
            for (Extension current : target.getExtensions()) {
                if (!current.getName().equals(ext.getName())) continue;
                found = true;
                if (current.getType() != ext.getType()) {
                    throw new IllegalStateException("Found different types for extension " + current.getName() + " : " + (Object)((Object)current.getType()) + " and " + (Object)((Object)ext.getType()));
                }
                boolean handled = false;
                for (FeatureExtensionHandler fem : context.getFeatureExtensionHandlers()) {
                    if (!fem.canMerge(current.getName())) continue;
                    fem.merge(target, source, current.getName());
                    handled = true;
                    break;
                }
                if (handled) continue;
                BuilderUtil.mergeExtensions(current, ext, artifactMergeAlg);
            }
            if (found) continue;
            target.getExtensions().add(ext);
        }
        for (Extension ext : target.getExtensions()) {
            for (FeatureExtensionHandler fem : context.getFeatureExtensionHandlers()) {
                fem.postProcess(target, ext.getName());
            }
        }
    }

    static void mergeExtensions(Application target, Feature source, ArtifactMerge artifactMergeAlg) {
        for (Extension ext : source.getExtensions()) {
            boolean found = false;
            for (Extension current : target.getExtensions()) {
                if (!current.getName().equals(ext.getName())) continue;
                found = true;
                if (current.getType() != ext.getType()) {
                    throw new IllegalStateException("Found different types for extension " + current.getName() + " : " + (Object)((Object)current.getType()) + " and " + (Object)((Object)ext.getType()));
                }
                BuilderUtil.mergeExtensions(current, ext, artifactMergeAlg);
            }
            if (found) continue;
            target.getExtensions().add(ext);
        }
    }

    private static void merge(JsonObject obj1, JsonObject obj2) {
        for (Map.Entry entry : obj2.entrySet()) {
            if (!obj1.containsKey(entry.getKey())) {
                obj1.put(entry.getKey(), entry.getValue());
                continue;
            }
            JsonValue oldValue = (JsonValue)obj1.get(entry.getKey());
            if (oldValue.getValueType() != ((JsonValue)entry.getValue()).getValueType()) {
                obj1.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (oldValue.getValueType() == JsonValue.ValueType.ARRAY) {
                JsonArrayBuilder builder = Json.createArrayBuilder();
                Stream.concat(((JsonArray)oldValue).stream(), ((JsonArray)entry.getValue()).stream()).forEachOrdered(arg_0 -> ((JsonArrayBuilder)builder).add(arg_0));
                obj1.put(entry.getKey(), (Object)builder.build());
                continue;
            }
            if (oldValue.getValueType() == JsonValue.ValueType.OBJECT) {
                BuilderUtil.merge((JsonObject)oldValue, (JsonObject)entry.getValue());
                continue;
            }
            obj1.put(entry.getKey(), entry.getValue());
        }
    }

    static enum ArtifactMerge {
        LATEST,
        HIGHEST;

    }
}

