/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.builder;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.sling.feature.builder.FeatureExtensionHandler;
import org.apache.sling.feature.builder.FeatureProvider;

public class BuilderContext {
    private final FeatureProvider provider;
    private final List<FeatureExtensionHandler> featureExtensionHandlers = new CopyOnWriteArrayList<FeatureExtensionHandler>();

    public BuilderContext(FeatureProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Provider must not be null");
        }
        this.provider = provider;
    }

    public BuilderContext add(FeatureExtensionHandler handler) {
        this.featureExtensionHandlers.add(handler);
        return this;
    }

    FeatureProvider getFeatureProvider() {
        return this.provider;
    }

    List<FeatureExtensionHandler> getFeatureExtensionHandlers() {
        return this.featureExtensionHandlers;
    }

    BuilderContext clone(FeatureProvider featureProvider) {
        BuilderContext ctx = new BuilderContext(featureProvider);
        ctx.featureExtensionHandlers.addAll(this.featureExtensionHandlers);
        return ctx;
    }
}

