/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.builder;

import org.apache.sling.feature.Application;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.BuilderContext;
import org.apache.sling.feature.builder.BuilderUtil;
import org.apache.sling.feature.builder.FeatureBuilder;

public class ApplicationBuilder {
    public static Application assemble(Application app, BuilderContext context, Feature ... features) {
        if (features == null || context == null) {
            throw new IllegalArgumentException("Features and/or context must not be null");
        }
        if (app == null) {
            app = new Application();
        }
        Feature[] assembledFeatures = FeatureBuilder.deduplicate(context, features);
        int featureStartOrder = 5;
        for (Feature assembled : assembledFeatures) {
            app.getFeatureIds().add(assembled.getId());
            int globalStartOrder = featureStartOrder;
            for (Artifact a : assembled.getBundles()) {
                int so = a.getStartOrder() + featureStartOrder;
                if (so > globalStartOrder) {
                    globalStartOrder = so;
                }
                a.setStartOrder(so);
            }
            featureStartOrder = globalStartOrder + 1;
            ApplicationBuilder.merge(app, assembled);
        }
        return app;
    }

    private static void merge(Application target, Feature source) {
        BuilderUtil.mergeBundles(target.getBundles(), source.getBundles(), BuilderUtil.ArtifactMerge.HIGHEST);
        BuilderUtil.mergeConfigurations(target.getConfigurations(), source.getConfigurations());
        BuilderUtil.mergeFrameworkProperties(target.getFrameworkProperties(), source.getFrameworkProperties());
        BuilderUtil.mergeExtensions(target, source, BuilderUtil.ArtifactMerge.HIGHEST);
    }
}

