/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.felix.utils.resource.CapabilityImpl;
import org.apache.felix.utils.resource.RequirementImpl;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Bundles;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Configurations;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.Extensions;
import org.apache.sling.feature.Include;
import org.apache.sling.feature.KeyValueMap;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

public class Feature
implements Comparable<Feature> {
    private final ArtifactId id;
    private final Bundles bundles = new Bundles();
    private final Configurations configurations = new Configurations();
    private final KeyValueMap frameworkProperties = new KeyValueMap();
    private final List<Requirement> requirements = new ArrayList<Requirement>();
    private final List<Capability> capabilities = new ArrayList<Capability>();
    private final List<Include> includes = new ArrayList<Include>();
    private final Extensions extensions = new Extensions();
    private final KeyValueMap variables = new KeyValueMap();
    private volatile String location;
    private volatile String title;
    private volatile String description;
    private volatile String vendor;
    private volatile String license;
    private volatile boolean assembled = false;

    public Feature(ArtifactId id) {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null.");
        }
        this.id = id;
    }

    public ArtifactId getId() {
        return this.id;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String value) {
        this.location = value;
    }

    public Bundles getBundles() {
        return this.bundles;
    }

    public Configurations getConfigurations() {
        return this.configurations;
    }

    public KeyValueMap getFrameworkProperties() {
        return this.frameworkProperties;
    }

    public List<Requirement> getRequirements() {
        return this.requirements;
    }

    public List<Capability> getCapabilities() {
        return this.capabilities;
    }

    public List<Include> getIncludes() {
        return this.includes;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public KeyValueMap getVariables() {
        return this.variables;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public boolean isAssembled() {
        return this.assembled;
    }

    public void setAssembled(boolean flag) {
        this.assembled = flag;
    }

    public Feature copy() {
        return this.copy(this.getId());
    }

    public Feature copy(ArtifactId id) {
        Object c;
        Feature result = new Feature(id);
        result.setLocation(this.getLocation());
        result.setTitle(this.getTitle());
        result.setDescription(this.getDescription());
        result.setVendor(this.getVendor());
        result.setLicense(this.getLicense());
        result.setAssembled(this.isAssembled());
        result.getVariables().putAll(this.getVariables());
        for (Artifact artifact : this.getBundles()) {
            c = new Artifact(artifact.getId());
            ((Artifact)c).getMetadata().putAll(artifact.getMetadata());
            result.getBundles().add((Artifact)c);
        }
        for (Configuration configuration : this.getConfigurations()) {
            c = configuration.isFactoryConfiguration() ? new Configuration(configuration.getFactoryPid(), configuration.getName()) : new Configuration(configuration.getPid());
            Enumeration<String> keyEnum = configuration.getProperties().keys();
            while (keyEnum.hasMoreElements()) {
                String key = keyEnum.nextElement();
                ((Configuration)c).getProperties().put(key, configuration.getProperties().get(key));
            }
            result.getConfigurations().add(c);
        }
        result.getFrameworkProperties().putAll(this.getFrameworkProperties());
        for (Requirement requirement : this.getRequirements()) {
            c = new RequirementImpl(null, requirement.getNamespace(), requirement.getDirectives(), requirement.getAttributes());
            result.getRequirements().add((Requirement)c);
        }
        for (Capability capability : this.getCapabilities()) {
            c = new CapabilityImpl(null, capability.getNamespace(), capability.getDirectives(), capability.getAttributes());
            result.getCapabilities().add((Capability)c);
        }
        for (Include include : this.getIncludes()) {
            c = new Include(include.getId());
            ((Include)c).getBundleRemovals().addAll(include.getBundleRemovals());
            ((Include)c).getConfigurationRemovals().addAll(include.getConfigurationRemovals());
            ((Include)c).getExtensionRemovals().addAll(include.getExtensionRemovals());
            ((Include)c).getFrameworkPropertiesRemovals().addAll(include.getFrameworkPropertiesRemovals());
            ((Include)c).getArtifactExtensionRemovals().putAll(((Include)c).getArtifactExtensionRemovals());
            result.getIncludes().add((Include)c);
        }
        for (Extension extension : this.getExtensions()) {
            c = new Extension(extension.getType(), extension.getName(), extension.isRequired());
            switch (((Extension)c).getType()) {
                case ARTIFACTS: {
                    for (Artifact a : extension.getArtifacts()) {
                        Artifact x = new Artifact(a.getId());
                        x.getMetadata().putAll(a.getMetadata());
                        ((Extension)c).getArtifacts().add(x);
                    }
                    break;
                }
                case JSON: {
                    ((Extension)c).setJSON(extension.getJSON());
                    break;
                }
                case TEXT: {
                    ((Extension)c).setText(extension.getText());
                }
            }
            result.getExtensions().add(c);
        }
        return result;
    }

    @Override
    public int compareTo(Feature o) {
        return this.id.compareTo(o.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.id.equals(((Feature)obj).id);
    }

    public String toString() {
        return (this.isAssembled() ? "Assembled Feature" : "Feature") + " [id=" + this.getId().toMvnId() + (this.getLocation() != null ? ", location=" + this.getLocation() : "") + "]";
    }
}

