/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature;

import java.util.Dictionary;
import java.util.Hashtable;

public class Configuration
implements Comparable<Configuration> {
    public static final String PROP_ARTIFACT = "service.bundleLocation";
    private final String pid;
    private final String factoryPid;
    private final Dictionary<String, Object> properties = new Hashtable<String, Object>();

    public Configuration(String pid) {
        if (pid == null) {
            throw new IllegalArgumentException("pid must not be null");
        }
        this.pid = pid;
        this.factoryPid = null;
    }

    public Configuration(String factoryPid, String name) {
        if (factoryPid == null || name == null) {
            throw new IllegalArgumentException("factoryPid and/or name must not be null");
        }
        this.pid = name;
        this.factoryPid = factoryPid;
    }

    private int compareString(String a, String b) {
        if (a == null) {
            if (b == null) {
                return 0;
            }
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    @Override
    public int compareTo(Configuration o) {
        int result = this.compareString(this.factoryPid, o.factoryPid);
        if (result == 0) {
            result = this.compareString(this.pid, o.pid);
        }
        return result;
    }

    public String getPid() {
        if (this.isFactoryConfiguration()) {
            return null;
        }
        return this.pid;
    }

    public String getFactoryPid() {
        return this.factoryPid;
    }

    public String getName() {
        if (this.isFactoryConfiguration()) {
            return this.pid;
        }
        return null;
    }

    public boolean isFactoryConfiguration() {
        return this.factoryPid != null;
    }

    public Dictionary<String, Object> getProperties() {
        return this.properties;
    }

    public String toString() {
        if (this.isFactoryConfiguration()) {
            return "Factory Configuration [factoryPid=" + this.factoryPid + ", name=" + this.pid + ", properties=" + this.properties + "]";
        }
        return "Configuration [pid=" + this.pid + ", properties=" + this.properties + "]";
    }
}

