/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature;

import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.KeyValueMap;

public class Artifact
implements Comparable<Artifact> {
    public static final String KEY_START_ORDER = "start-order";
    private final ArtifactId id;
    private final KeyValueMap metadata = new KeyValueMap();

    public Artifact(ArtifactId id) {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null.");
        }
        this.id = id;
    }

    public ArtifactId getId() {
        return this.id;
    }

    public KeyValueMap getMetadata() {
        return this.metadata;
    }

    public int getStartOrder() {
        int startOrder;
        String order = this.getMetadata().get(KEY_START_ORDER);
        if (order != null) {
            startOrder = Integer.parseInt(order);
            if (startOrder < 0) {
                throw new IllegalStateException("Start order must be >= 0 but is " + order);
            }
        } else {
            startOrder = 0;
        }
        return startOrder;
    }

    public void setStartOrder(int startOrder) {
        if (startOrder < 0) {
            throw new IllegalArgumentException("Start order must be >= 0 but is " + startOrder);
        }
        if (startOrder == 0) {
            this.getMetadata().remove(KEY_START_ORDER);
        } else {
            this.getMetadata().put(KEY_START_ORDER, String.valueOf(startOrder));
        }
    }

    @Override
    public int compareTo(Artifact o) {
        return this.id.compareTo(o.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.id.equals(((Artifact)obj).id);
    }

    public String toString() {
        return "Artifact [id=" + this.id.toMvnId() + "]";
    }
}

