/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.builder;

import java.util.ArrayList;
import org.apache.sling.feature.Application;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.BuilderContext;
import org.apache.sling.feature.builder.BuilderUtil;
import org.apache.sling.feature.builder.FeatureBuilder;
import org.apache.sling.feature.builder.FeatureProvider;

public class ApplicationBuilder {
    public static Application assemble(Application app, BuilderContext context, String ... featureIds) {
        if (featureIds == null || context == null) {
            throw new IllegalArgumentException("Features and/or context must not be null");
        }
        Feature[] features = new Feature[featureIds.length];
        int index = 0;
        for (String id : featureIds) {
            features[index] = context.getFeatureProvider().provide(ArtifactId.parse(id));
            if (features[index] == null) {
                throw new IllegalStateException("Unable to find included feature " + id);
            }
            ++index;
        }
        return ApplicationBuilder.assemble(app, context, features);
    }

    public static Application assemble(Application app, final BuilderContext context, final Feature ... features) {
        if (features == null || context == null) {
            throw new IllegalArgumentException("Features and/or context must not be null");
        }
        if (app == null) {
            app = new Application();
        }
        ArrayList<Feature> featureList = new ArrayList<Feature>();
        for (Feature f : features) {
            Feature found = null;
            for (Feature s : featureList) {
                if (!s.getId().isSame(f.getId())) continue;
                found = s;
                break;
            }
            boolean add = true;
            if (found != null) {
                if (f.getId().getOSGiVersion().compareTo(found.getId().getOSGiVersion()) <= 0) {
                    add = false;
                } else {
                    featureList.remove(found);
                }
            }
            if (!add) continue;
            featureList.add(f);
        }
        int featureStartOrder = 5;
        for (Feature f : featureList) {
            app.getFeatureIds().add(f.getId());
            Feature assembled = FeatureBuilder.assemble(f, context.clone(new FeatureProvider(){

                @Override
                public Feature provide(ArtifactId id) {
                    for (Feature f : features) {
                        if (!f.getId().equals(id)) continue;
                        return f;
                    }
                    return context.getFeatureProvider().provide(id);
                }
            }));
            int globalStartOrder = featureStartOrder;
            for (Artifact a : assembled.getBundles()) {
                int so = a.getStartOrder() + featureStartOrder;
                if (so > globalStartOrder) {
                    globalStartOrder = so;
                }
                a.setStartOrder(so);
            }
            featureStartOrder = globalStartOrder + 1;
            ApplicationBuilder.merge(app, assembled);
        }
        return app;
    }

    private static void merge(Application target, Feature source) {
        BuilderUtil.mergeBundles(target.getBundles(), source.getBundles(), BuilderUtil.ArtifactMerge.HIGHEST);
        BuilderUtil.mergeConfigurations(target.getConfigurations(), source.getConfigurations());
        BuilderUtil.mergeFrameworkProperties(target.getFrameworkProperties(), source.getFrameworkProperties());
        BuilderUtil.mergeExtensions(target, source, BuilderUtil.ArtifactMerge.HIGHEST);
    }
}

