/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class KeyValueMap
implements Iterable<Map.Entry<String, String>> {
    private final Map<String, Object> properties = new TreeMap<String, Object>();

    public String get(String key) {
        Object val = this.properties.get(key);
        if (val instanceof String) {
            return (String)val;
        }
        return null;
    }

    public Object getObject(String key) {
        return this.properties.get(key);
    }

    public void put(String key, Object value) {
        this.properties.put(key, value);
    }

    public Object remove(String key) {
        return this.properties.remove(key);
    }

    public void putAll(KeyValueMap map) {
        this.properties.putAll(map.properties);
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        TreeMap<String, String> copied = new TreeMap<String, String>();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            copied.put(entry.getKey(), (String)entry.getValue());
        }
        return copied.entrySet().iterator();
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public String toString() {
        return this.properties.toString();
    }

    public int size() {
        return this.properties.size();
    }

    public void clear() {
        this.properties.clear();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyValueMap other = (KeyValueMap)obj;
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }
}

