/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature;

import java.util.ArrayList;
import java.util.List;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ExtensionType;

public class Extension {
    private final ExtensionType type;
    private final String name;
    private final List<Artifact> artifacts;
    private String text;
    private final boolean required;

    public Extension(ExtensionType t, String name, boolean required) {
        if (t == null || name == null) {
            throw new IllegalArgumentException("Argument must not be null");
        }
        this.type = t;
        this.name = name;
        this.required = required;
        this.artifacts = t == ExtensionType.ARTIFACTS ? new ArrayList<Artifact>() : null;
    }

    public ExtensionType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isOptional() {
        return !this.isRequired();
    }

    public String getText() {
        if (this.type != ExtensionType.TEXT) {
            throw new IllegalStateException();
        }
        return this.text;
    }

    public void setText(String text) {
        if (this.type != ExtensionType.TEXT) {
            throw new IllegalStateException();
        }
        this.text = text;
    }

    public String getJSON() {
        if (this.type != ExtensionType.JSON) {
            throw new IllegalStateException();
        }
        return this.text;
    }

    public void setJSON(String text) {
        if (this.type != ExtensionType.JSON) {
            throw new IllegalStateException();
        }
        this.text = text;
    }

    public List<Artifact> getArtifacts() {
        if (this.type != ExtensionType.ARTIFACTS) {
            throw new IllegalStateException();
        }
        return this.artifacts;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.name.equals(((Extension)obj).name);
    }

    public String toString() {
        return "Extension [type=" + (Object)((Object)this.type) + ", name=" + this.name + "]";
    }
}

