/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;

public class Bundles
implements Iterable<Artifact> {
    private final List<Artifact> bundles = new ArrayList<Artifact>();

    public Map<Integer, List<Artifact>> getBundlesByStartOrder() {
        TreeMap<Integer, ArrayList<Artifact>> startOrderMap = new TreeMap<Integer, ArrayList<Artifact>>(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == 0) {
                    return 1;
                }
                if (o2 == 0) {
                    return -1;
                }
                return o1 - o2;
            }
        });
        for (Artifact bundle : this.bundles) {
            int startOrder = bundle.getStartOrder();
            ArrayList<Artifact> list = (ArrayList<Artifact>)startOrderMap.get(startOrder);
            if (list == null) {
                list = new ArrayList<Artifact>();
                startOrderMap.put(startOrder, list);
            }
            list.add(bundle);
        }
        return Collections.unmodifiableMap(startOrderMap);
    }

    public void add(Artifact bundle) {
        this.bundles.add(bundle);
    }

    public boolean removeExact(ArtifactId id) {
        for (Artifact artifact : this.bundles) {
            if (!artifact.getId().equals(id)) continue;
            this.bundles.remove(artifact);
            return true;
        }
        return false;
    }

    public boolean removeSame(ArtifactId id) {
        for (Artifact artifact : this.bundles) {
            if (!artifact.getId().isSame(id)) continue;
            this.bundles.remove(artifact);
            return true;
        }
        return false;
    }

    public void clear() {
        this.bundles.clear();
    }

    public Artifact getSame(ArtifactId id) {
        for (Artifact bundle : this.bundles) {
            if (!bundle.getId().isSame(id)) continue;
            return bundle;
        }
        return null;
    }

    public boolean containsExact(ArtifactId id) {
        for (Artifact entry : this.bundles) {
            if (!entry.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public boolean containsSame(ArtifactId id) {
        for (Artifact entry : this.bundles) {
            if (!entry.getId().isSame(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Artifact> iterator() {
        return Collections.unmodifiableList(this.bundles).iterator();
    }

    public boolean isEmpty() {
        return this.bundles.isEmpty();
    }

    public String toString() {
        return "Bundles " + this.bundles;
    }
}

