/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.extensions.webconsolesecurityprovider.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.webconsole.WebConsoleSecurityProvider;
import org.apache.sling.extensions.webconsolesecurityprovider.internal.SlingWebConsoleSecurityProvider;
import org.apache.sling.extensions.webconsolesecurityprovider.internal.SlingWebConsoleSecurityProvider2;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedService;

public class ServicesListener {
    private static final String AUTH_SUPPORT_CLASS = "org.apache.sling.auth.core.AuthenticationSupport";
    private static final String AUTHENTICATOR_CLASS = "org.apache.sling.api.auth.Authenticator";
    private static final String REPO_CLASS = "javax.jcr.Repository";
    private final BundleContext bundleContext;
    private final Listener repositoryListener;
    private final Listener authSupportListener;
    private final Listener authListener;
    private volatile State registrationState = State.NONE;
    private ServiceRegistration<?> providerReg;
    private ServiceRegistration<?> provider2Reg;

    public ServicesListener(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.authSupportListener = new Listener(AUTH_SUPPORT_CLASS);
        this.repositoryListener = new Listener(REPO_CLASS);
        this.authListener = new Listener(AUTHENTICATOR_CLASS);
        this.authSupportListener.start();
        this.repositoryListener.start();
        this.authListener.start();
    }

    public synchronized void notifyChange() {
        Object authSupport = this.authSupportListener.getService();
        Object authenticator = this.authListener.getService();
        boolean hasAuthServices = authSupport != null && authenticator != null;
        Object repository = this.repositoryListener.getService();
        if (this.registrationState == State.NONE) {
            if (hasAuthServices) {
                this.registerProvider2(authSupport, authenticator);
            } else if (repository != null) {
                this.registerProvider(repository);
            }
        } else if (this.registrationState == State.PROVIDER) {
            if (hasAuthServices) {
                this.registerProvider2(authSupport, authenticator);
                this.unregisterProvider();
            } else if (repository == null) {
                this.unregisterProvider();
                this.registrationState = State.NONE;
            }
        } else if (authSupport == null) {
            if (repository != null) {
                this.registerProvider(repository);
            } else {
                this.registrationState = State.NONE;
            }
            this.unregisterProvider2();
        }
    }

    private void unregisterProvider2() {
        if (this.provider2Reg != null) {
            this.provider2Reg.unregister();
            this.provider2Reg = null;
        }
    }

    private void unregisterProvider() {
        if (this.providerReg != null) {
            this.providerReg.unregister();
            this.providerReg = null;
        }
    }

    private void registerProvider2(Object authSupport, Object authenticator) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", SlingWebConsoleSecurityProvider.class.getName());
        ((Dictionary)props).put("service.description", "Apache Sling Web Console Security Provider 2");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)props).put("webconsole.security.provider.id", "org.apache.sling.extensions.webconsolesecurityprovider2");
        this.provider2Reg = this.bundleContext.registerService(new String[]{ManagedService.class.getName(), WebConsoleSecurityProvider.class.getName()}, (Object)new SlingWebConsoleSecurityProvider2(authSupport, authenticator), props);
        this.registrationState = State.PROVIDER2;
    }

    private void registerProvider(Object repository) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", SlingWebConsoleSecurityProvider.class.getName());
        ((Dictionary)props).put("service.description", "Apache Sling Web Console Security Provider");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)props).put("webconsole.security.provider.id", "org.apache.sling.extensions.webconsolesecurityprovider");
        this.providerReg = this.bundleContext.registerService(new String[]{ManagedService.class.getName(), WebConsoleSecurityProvider.class.getName()}, (Object)new SlingWebConsoleSecurityProvider(repository), props);
        this.registrationState = State.PROVIDER;
    }

    public void deactivate() {
        this.repositoryListener.deactivate();
        this.authSupportListener.deactivate();
        this.authListener.deactivate();
        this.unregisterProvider();
        this.unregisterProvider2();
    }

    protected final class Listener
    implements ServiceListener {
        private final String serviceName;
        private volatile ServiceReference<?> reference;
        private volatile Object service;

        public Listener(String serviceName) {
            this.serviceName = serviceName;
        }

        public void start() {
            try {
                ServicesListener.this.bundleContext.addServiceListener((ServiceListener)this, "(objectClass=" + this.serviceName + ")");
            }
            catch (InvalidSyntaxException ise) {
                throw new RuntimeException("Unexpected exception occured.", ise);
            }
            ServiceReference ref = ServicesListener.this.bundleContext.getServiceReference(this.serviceName);
            if (ref != null) {
                this.retainService(ref);
            }
        }

        public void deactivate() {
            ServicesListener.this.bundleContext.removeServiceListener((ServiceListener)this);
        }

        public synchronized Object getService() {
            return this.service;
        }

        private synchronized void retainService(ServiceReference<?> ref) {
            int result;
            boolean getService;
            boolean hadService = this.service != null;
            boolean bl = getService = this.reference == null;
            if (!getService && (result = this.reference.compareTo(ref)) < 0) {
                ServicesListener.this.bundleContext.ungetService(this.reference);
                this.service = null;
                getService = true;
            }
            if (getService) {
                this.reference = ref;
                this.service = ServicesListener.this.bundleContext.getService(this.reference);
                if (this.service == null) {
                    this.reference = null;
                } else {
                    ServicesListener.this.notifyChange();
                }
            }
            if (hadService && this.service == null) {
                ServicesListener.this.notifyChange();
            }
        }

        private synchronized void releaseService(ServiceReference<?> ref) {
            if (this.reference != null && this.reference.compareTo(ref) == 0) {
                this.service = null;
                ServicesListener.this.bundleContext.ungetService(this.reference);
                this.reference = null;
                ServicesListener.this.notifyChange();
            }
        }

        public void serviceChanged(ServiceEvent event) {
            if (event.getType() == 1) {
                this.retainService(event.getServiceReference());
            } else if (event.getType() == 4) {
                this.releaseService(event.getServiceReference());
            } else if (event.getType() == 2) {
                ServicesListener.this.notifyChange();
            }
        }
    }

    private static enum State {
        NONE,
        PROVIDER,
        PROVIDER2;

    }
}

