/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.extensions.webconsolesecurityprovider.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Set;
import org.apache.felix.webconsole.WebConsoleSecurityProvider;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebConsoleSecurityProvider
implements WebConsoleSecurityProvider,
ManagedService {
    private static final String PROP_USERS = "users";
    public static final String PROP_GROUPS_DEFAULT_USER = "admin";
    private static final String PROP_GROUPS = "groups";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Set<String> users = Collections.singleton("admin");
    protected Set<String> groups = Collections.emptySet();

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        this.users = this.toSet(properties == null ? null : properties.get(PROP_USERS), PROP_GROUPS_DEFAULT_USER);
        this.groups = this.toSet(properties == null ? null : properties.get(PROP_GROUPS), null);
    }

    private Set<String> toSet(Object configObj, String defaultUser) {
        HashSet<String> groups = new HashSet<String>();
        if (configObj instanceof String) {
            groups.add((String)configObj);
        } else if (configObj instanceof Collection) {
            for (Object obj : (Collection)configObj) {
                if (!(obj instanceof String)) continue;
                groups.add((String)obj);
            }
        } else if (configObj instanceof String[]) {
            for (String string : (String[])configObj) {
                if (string == null) continue;
                groups.add(string);
            }
        } else if (configObj == null && defaultUser != null) {
            groups.add(defaultUser);
        }
        return groups;
    }
}

