/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.event.impl.jobs.JobImpl;
import org.apache.sling.event.impl.jobs.Utility;
import org.apache.sling.event.impl.jobs.config.JobManagerConfiguration;
import org.apache.sling.event.impl.jobs.config.QueueConfigurationManager;
import org.apache.sling.event.impl.jobs.config.TopologyCapabilities;
import org.apache.sling.event.impl.support.ResourceHelper;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.Queue;
import org.apache.sling.event.jobs.consumer.JobExecutor;

public class JobHandler {
    private final JobImpl job;
    public volatile long started = -1L;
    private volatile boolean isStopped = false;
    private final JobManagerConfiguration configuration;
    private final int progressLogMaxCount;
    private final JobExecutor consumer;

    public JobHandler(JobImpl job, JobExecutor consumer, JobManagerConfiguration configuration) {
        this.job = job;
        this.consumer = consumer;
        this.configuration = configuration;
        this.progressLogMaxCount = configuration.getProgressLogMaxCount();
    }

    public JobImpl getJob() {
        return this.job;
    }

    public int getProgressLogMaxCount() {
        return this.progressLogMaxCount;
    }

    public JobExecutor getConsumer() {
        return this.consumer;
    }

    public boolean startProcessing(Queue queue) {
        this.isStopped = false;
        return this.persistJobProperties(this.job.prepare(queue));
    }

    public boolean reschedule() {
        return this.withJobResource((jobResource, mvm) -> {
            mvm.put((Object)"event.job.retrycount", this.job.getProperty("event.job.retrycount", Integer.class));
            if (this.job.getProperty("slingevent:resultMessage") != null) {
                mvm.put((Object)"slingevent:resultMessage", this.job.getProperty("slingevent:resultMessage"));
            }
            mvm.remove((Object)"event.job.started.time");
            mvm.put((Object)"event.job.queued.time", (Object)Calendar.getInstance());
            try {
                jobResource.getResourceResolver().commit();
                return true;
            }
            catch (PersistenceException pe) {
                this.configuration.getMainLogger().debug("Unable to update reschedule properties for job " + this.job.getId(), (Throwable)pe);
                return false;
            }
        });
    }

    public void finished(Job.JobState state, boolean keepJobInHistory, Long duration) {
        boolean isSuccess = state == Job.JobState.SUCCEEDED;
        this.withJobResource((jobResource, mvm) -> {
            try {
                ResourceResolver rr = jobResource.getResourceResolver();
                String newPath = null;
                if (keepJobInHistory) {
                    newPath = this.configuration.getStoragePath(this.job.getTopic(), this.job.getId(), isSuccess);
                    HashMap<String, Object> props = new HashMap<String, Object>((Map<String, Object>)mvm);
                    props.put("slingevent:finishedState", state.name());
                    if (isSuccess) {
                        Date finishDate = new Date();
                        finishDate.setTime(this.job.getProcessingStarted().getTime().getTime() + duration);
                        Calendar finishCal = Calendar.getInstance();
                        finishCal.setTime(finishDate);
                        props.put("slingevent:finishedDate", finishCal);
                    } else {
                        props.put("slingevent:finishedDate", Calendar.getInstance());
                    }
                    if (this.job.getProperty("slingevent:resultMessage") != null) {
                        props.put("slingevent:resultMessage", this.job.getProperty("slingevent:resultMessage"));
                    }
                    ResourceHelper.getOrCreateResource(rr, newPath, props);
                }
                rr.delete(jobResource);
                rr.commit();
                if (keepJobInHistory && this.configuration.getMainLogger().isDebugEnabled()) {
                    if (isSuccess) {
                        this.configuration.getMainLogger().debug("Kept successful job {} at {}", (Object)Utility.toString(this.job), (Object)newPath);
                    } else {
                        this.configuration.getMainLogger().debug("Moved cancelled job {} to {}", (Object)Utility.toString(this.job), (Object)newPath);
                    }
                }
            }
            catch (PersistenceException pe) {
                this.configuration.getMainLogger().warn("Unable to finish job " + this.job.getId(), (Throwable)pe);
            }
            return false;
        });
    }

    public void reassign() {
        QueueConfigurationManager.QueueInfo queueInfo = this.configuration.getQueueConfigurationManager().getQueueInfo(this.job.getTopic());
        TopologyCapabilities caps = this.configuration.getTopologyCapabilities();
        String targetId = caps == null ? null : caps.detectTarget(this.job.getTopic(), this.job.getProperties(), queueInfo);
        this.withJobResource((jobResource, mvm) -> {
            String newPath = this.configuration.getUniquePath(targetId, this.job.getTopic(), this.job.getId(), this.job.getProperties());
            HashMap<String, Object> props = new HashMap<String, Object>((Map<String, Object>)mvm);
            props.remove("event.job.queuename");
            if (targetId == null) {
                props.remove("event.job.application");
            } else {
                props.put("event.job.application", targetId);
            }
            props.remove("event.job.started.time");
            try {
                ResourceResolver r = jobResource.getResourceResolver();
                ResourceHelper.getOrCreateResource(r, newPath, props);
                r.delete(jobResource);
                r.commit();
            }
            catch (PersistenceException pe) {
                this.configuration.getMainLogger().warn("Unable to reassign job " + this.job.getId(), (Throwable)pe);
            }
            return true;
        });
    }

    public boolean persistJobProperties(String ... propNames) {
        if (propNames == null) {
            return true;
        }
        return this.withJobResource((jobResource, mvm) -> {
            for (String propName : propNames) {
                Object val = this.job.getProperty(propName);
                if (val != null) {
                    if (val.getClass().isEnum()) {
                        mvm.put((Object)propName, (Object)val.toString());
                        continue;
                    }
                    mvm.put((Object)propName, val);
                    continue;
                }
                mvm.remove((Object)propName);
            }
            try {
                jobResource.getResourceResolver().commit();
                return true;
            }
            catch (PersistenceException ignore) {
                this.configuration.getMainLogger().debug("Unable to persist properties", (Throwable)ignore);
                return false;
            }
        });
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public void stop() {
        this.isStopped = true;
    }

    public void addToRetryList() {
        this.configuration.addJobToRetryList(this.job);
    }

    public boolean removeFromRetryList() {
        return this.configuration.removeJobFromRetryList(this.job);
    }

    public int hashCode() {
        return this.job.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JobHandler)) {
            return false;
        }
        return this.job.getId().equals(((JobHandler)obj).job.getId());
    }

    public String toString() {
        return "JobHandler(" + this.job.getId() + ")";
    }

    private boolean withJobResource(BiFunction<Resource, ModifiableValueMap, Boolean> func) {
        try (ResourceResolver resolver = this.configuration.createResourceResolver();){
            Resource jobResource = resolver.getResource(this.job.getResourcePath());
            if (jobResource == null) {
                this.configuration.getMainLogger().debug("No job resource found at {}", (Object)this.job.getResourcePath());
                boolean bl = false;
                return bl;
            }
            ModifiableValueMap mvm = (ModifiableValueMap)jobResource.adaptTo(ModifiableValueMap.class);
            if (mvm == null) {
                this.configuration.getMainLogger().debug("Cannot adapt resource {} to ModifiableValueMap, no write permissions?", (Object)this.job.getResourcePath());
                boolean bl = false;
                return bl;
            }
            boolean bl = func.apply(jobResource, mvm);
            return bl;
        }
    }
}

