/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.queues;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sling.event.impl.jobs.JobHandler;
import org.apache.sling.event.impl.jobs.queues.ResultBuilderImpl;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.consumer.JobExecutionContext;
import org.apache.sling.event.jobs.consumer.JobExecutionResult;
import org.jetbrains.annotations.NotNull;

public class JobExecutionContextImpl
implements JobExecutionContext {
    private final AtomicBoolean initProgressIsCalled = new AtomicBoolean(false);
    private final AtomicBoolean isAsync = new AtomicBoolean(false);
    private final ASyncHandler asyncHandler;
    private final JobHandler handler;

    public JobExecutionContextImpl(JobHandler handler, ASyncHandler asyncHandler) {
        this.handler = handler;
        this.asyncHandler = asyncHandler;
    }

    public void markAsync() {
        this.isAsync.set(true);
    }

    @Override
    public void initProgress(int steps, long eta) {
        if (this.initProgressIsCalled.compareAndSet(false, true)) {
            this.handler.persistJobProperties(this.handler.getJob().startProgress(steps, eta));
        }
    }

    @Override
    public void incrementProgressCount(int steps) {
        if (this.initProgressIsCalled.get()) {
            this.handler.persistJobProperties(this.handler.getJob().setProgress(steps));
        }
    }

    @Override
    public void updateProgress(long eta) {
        if (this.initProgressIsCalled.get()) {
            this.handler.persistJobProperties(this.handler.getJob().update(eta));
        }
    }

    @Override
    public void setProperty(@NotNull String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null");
        }
        if (name.startsWith("slingevent:") || name.startsWith(":slingevent:")) {
            throw new IllegalArgumentException("Property name must not start with slingevent: or :slingevent: " + name);
        }
        this.handler.getJob().setProperty(name, value);
        this.handler.persistJobProperties(name);
    }

    @Override
    public void log(@NotNull String message, Object ... args) {
        int logMaxCount = this.handler.getProgressLogMaxCount();
        this.handler.persistJobProperties(this.handler.getJob().log(logMaxCount, message, args));
    }

    @Override
    public boolean isStopped() {
        return this.handler.isStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncProcessingFinished(JobExecutionResult result) {
        JobExecutionContextImpl jobExecutionContextImpl = this;
        synchronized (jobExecutionContextImpl) {
            Job.JobState state;
            if (this.isAsync.compareAndSet(true, false)) {
                state = null;
                if (result.succeeded()) {
                    state = Job.JobState.SUCCEEDED;
                } else if (result.failed()) {
                    state = Job.JobState.QUEUED;
                } else if (result.cancelled()) {
                    state = this.handler.isStopped() ? Job.JobState.STOPPED : Job.JobState.ERROR;
                }
            } else {
                throw new IllegalStateException("Job is not processed async or is already finished: " + this.handler.getJob().getId());
            }
            this.asyncHandler.finished(state);
        }
    }

    @Override
    public JobExecutionContext.ResultBuilder result() {
        return new ResultBuilderImpl();
    }

    public static interface ASyncHandler {
        public void finished(Job.JobState var1);
    }
}

