/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.config;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.event.impl.EnvironmentComponent;
import org.apache.sling.event.impl.discovery.InitDelayingTopologyEventListener;
import org.apache.sling.event.impl.jobs.config.ConfigurationChangeListener;
import org.apache.sling.event.impl.jobs.config.QueueConfigurationManager;
import org.apache.sling.event.impl.jobs.config.TopologyCapabilities;
import org.apache.sling.event.impl.jobs.tasks.CheckTopologyTask;
import org.apache.sling.event.impl.jobs.tasks.FindUnfinishedJobsTask;
import org.apache.sling.event.impl.jobs.tasks.UpgradeTask;
import org.apache.sling.event.impl.support.Environment;
import org.apache.sling.event.impl.support.ResourceHelper;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={JobManagerConfiguration.class}, name="org.apache.sling.event.impl.jobs.jcr.PersistenceHandler", property={"service.vendor=The Apache Software Foundation", "repository.path=/var/eventing/jobs", "job.scheduled.jobs.path=/var/eventing/scheduled-jobs", "load.delay:Long=10"})
@Designate(ocd=Config.class)
public class JobManagerConfiguration {
    private final Logger logger = LoggerFactory.getLogger((String)"org.apache.sling.event.impl.jobs");
    private final Logger auditLogger = LoggerFactory.getLogger((String)"org.apache.sling.event.jobs.audit");
    public static final String DEFAULT_REPOSITORY_PATH = "/var/eventing/jobs";
    public static final long DEFAULT_BACKGROUND_LOAD_DELAY = 10L;
    public static final String DEFAULT_SCHEDULED_JOBS_PATH = "/var/eventing/scheduled-jobs";
    public static final String PROPERTY_REPOSITORY_PATH = "repository.path";
    public static final String PROPERTY_BACKGROUND_LOAD_DELAY = "load.delay";
    public static final String PROPERTY_SCHEDULED_JOBS_PATH = "job.scheduled.jobs.path";
    private String jobsBasePathWithSlash;
    private String assignedJobsPath;
    private String unassignedJobsPath;
    private String localJobsPath;
    private String localJobsPathWithSlash;
    private String previousVersionAnonPath;
    private String previousVersionIdentifiedPath;
    private volatile long backgroundLoadDelay;
    private volatile long startupDelay;
    private int progressLogMaxCount;
    private volatile InitDelayingTopologyEventListener startupDelayListener;
    private volatile boolean disabledDistribution;
    private String storedCancelledJobsPath;
    private String storedSuccessfulJobsPath;
    private String scheduledJobsPath;
    private String scheduledJobsPathWithSlash;
    private volatile int historyCleanUpRemovedJobs;
    private final List<ConfigurationChangeListener> listeners = new ArrayList<ConfigurationChangeListener>();
    @Reference
    private EnvironmentComponent environment;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private QueueConfigurationManager queueConfigManager;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ServiceUserMapped serviceUserMapped;
    private final AtomicBoolean active = new AtomicBoolean(false);
    private volatile TopologyCapabilities topologyCapabilities;
    private final AtomicLong jobCounter = new AtomicLong(0L);
    private final Map<String, Job> retryList = new HashMap<String, Job>();

    static JobManagerConfiguration newForTest(ResourceResolverFactory resourceResolverFactory, QueueConfigurationManager queueConfigurationManager, Map<String, Object> activateProps, Config config) {
        JobManagerConfiguration jobMgrConfig = new JobManagerConfiguration();
        jobMgrConfig.resourceResolverFactory = resourceResolverFactory;
        jobMgrConfig.queueConfigManager = queueConfigurationManager;
        jobMgrConfig.activate(activateProps, config);
        return jobMgrConfig;
    }

    @Activate
    protected void activate(Map<String, Object> props, Config config) {
        this.update(props, config);
        this.jobsBasePathWithSlash = PropertiesUtil.toString(props.get(PROPERTY_REPOSITORY_PATH), DEFAULT_REPOSITORY_PATH) + '/';
        this.assignedJobsPath = this.jobsBasePathWithSlash + "assigned";
        this.unassignedJobsPath = this.jobsBasePathWithSlash + "unassigned";
        this.localJobsPath = this.assignedJobsPath.concat("/").concat(Environment.APPLICATION_ID);
        this.localJobsPathWithSlash = this.localJobsPath.concat("/");
        this.previousVersionAnonPath = this.jobsBasePathWithSlash + "anon";
        this.previousVersionIdentifiedPath = this.jobsBasePathWithSlash + "identified";
        this.storedCancelledJobsPath = this.jobsBasePathWithSlash + "cancelled";
        this.storedSuccessfulJobsPath = this.jobsBasePathWithSlash + "finished";
        this.scheduledJobsPath = PropertiesUtil.toString(props.get(PROPERTY_SCHEDULED_JOBS_PATH), DEFAULT_SCHEDULED_JOBS_PATH);
        this.scheduledJobsPathWithSlash = this.scheduledJobsPath + "/";
        this.historyCleanUpRemovedJobs = config.cleanup_period();
        try (ResourceResolver resolver = this.createResourceResolver();){
            ResourceHelper.getOrCreateBasePath(resolver, this.getLocalJobsPath());
            ResourceHelper.getOrCreateBasePath(resolver, this.getUnassignedJobsPath());
        }
        this.active.set(true);
        if (this.startupDelay > 0L) {
            this.logger.debug("activate: job manager will start in {} sec. ({})", (Object)this.startupDelay, (Object)config.startup_delay());
            this.startupDelayListener = new InitDelayingTopologyEventListener(this.startupDelay, new TopologyEventListener(){

                public void handleTopologyEvent(TopologyEvent event) {
                    JobManagerConfiguration.this.doHandleTopologyEvent(event);
                }
            });
        } else {
            this.logger.debug("activate: job manager will start without delay. ({}:{})", (Object)config.startup_delay(), (Object)this.startupDelay);
        }
    }

    @Modified
    protected void update(Map<String, Object> props, Config config) {
        this.disabledDistribution = config.job_consumermanager_disableDistribution();
        this.backgroundLoadDelay = PropertiesUtil.toLong(props.get(PROPERTY_BACKGROUND_LOAD_DELAY), 10L);
        this.startupDelay = config.startup_delay();
        this.progressLogMaxCount = config.progresslog_maxCount() < 0 ? Integer.MAX_VALUE : config.progresslog_maxCount();
    }

    @Deactivate
    protected void deactivate() {
        this.active.set(false);
        if (this.startupDelayListener != null) {
            this.startupDelayListener.dispose();
            this.startupDelayListener = null;
        }
        this.stopProcessing();
    }

    public int getHistoryCleanUpRemovedJobs() {
        return this.historyCleanUpRemovedJobs;
    }

    public boolean isActive() {
        return this.active.get();
    }

    public ResourceResolver createResourceResolver() {
        ResourceResolver resolver = null;
        ResourceResolverFactory factory = this.resourceResolverFactory;
        if (factory != null) {
            try {
                resolver = this.resourceResolverFactory.getServiceResourceResolver(null);
            }
            catch (LoginException le) {
                this.logger.error("Unable to create new resource resolver: " + le.getMessage(), (Throwable)le);
                throw new RuntimeException(le);
            }
        }
        return resolver;
    }

    public TopologyCapabilities getTopologyCapabilities() {
        return this.topologyCapabilities;
    }

    public QueueConfigurationManager getQueueConfigurationManager() {
        return this.queueConfigManager;
    }

    public Logger getMainLogger() {
        return this.logger;
    }

    public String getAssginedJobsPath() {
        return this.assignedJobsPath;
    }

    public String getUnassignedJobsPath() {
        return this.unassignedJobsPath;
    }

    public String getLocalJobsPath() {
        return this.localJobsPath;
    }

    public String getUniquePath(String targetId, String topic, String jobId, Map<String, Object> jobProperties) {
        String topicName = topic.replace('/', '.');
        StringBuilder sb = new StringBuilder();
        if (targetId != null) {
            sb.append(this.getAssginedJobsPath());
            sb.append('/');
            sb.append(targetId);
        } else {
            sb.append(this.getUnassignedJobsPath());
        }
        sb.append('/');
        sb.append(topicName);
        sb.append('/');
        sb.append(jobId);
        return sb.toString();
    }

    public String getUniqueId(String jobTopic) {
        Calendar now = Calendar.getInstance();
        StringBuilder sb = new StringBuilder();
        sb.append(now.get(1));
        sb.append('/');
        sb.append(now.get(2) + 1);
        sb.append('/');
        sb.append(now.get(5));
        sb.append('/');
        sb.append(now.get(11));
        sb.append('/');
        sb.append(now.get(12));
        sb.append('/');
        sb.append(Environment.APPLICATION_ID);
        sb.append('_');
        sb.append(this.jobCounter.getAndIncrement());
        return sb.toString();
    }

    public boolean isLocalJob(String jobPath) {
        return jobPath != null && jobPath.startsWith(this.localJobsPathWithSlash);
    }

    public boolean isJob(String jobPath) {
        return jobPath.startsWith(this.jobsBasePathWithSlash);
    }

    public String getJobsBasePathWithSlash() {
        return this.jobsBasePathWithSlash;
    }

    public int getProgressLogMaxCount() {
        return this.progressLogMaxCount;
    }

    public String getPreviousVersionAnonPath() {
        return this.previousVersionAnonPath;
    }

    public String getPreviousVersionIdentifiedPath() {
        return this.previousVersionIdentifiedPath;
    }

    public boolean disableDistribution() {
        return this.disabledDistribution;
    }

    public String getStoredCancelledJobsPath() {
        return this.storedCancelledJobsPath;
    }

    public String getStoredSuccessfulJobsPath() {
        return this.storedSuccessfulJobsPath;
    }

    public String getStoragePath(String topic, String jobId, boolean isSuccess) {
        String topicName = topic.replace('/', '.');
        StringBuilder sb = new StringBuilder();
        if (isSuccess) {
            sb.append(this.getStoredSuccessfulJobsPath());
        } else {
            sb.append(this.getStoredCancelledJobsPath());
        }
        sb.append('/');
        sb.append(topicName);
        sb.append('/');
        sb.append(jobId);
        return sb.toString();
    }

    public boolean isStoragePath(String path) {
        return path.startsWith(this.storedCancelledJobsPath) || path.startsWith(this.storedSuccessfulJobsPath);
    }

    public String getScheduledJobsPath(boolean slash) {
        return slash ? this.scheduledJobsPathWithSlash : this.scheduledJobsPath;
    }

    private void stopProcessing() {
        this.logger.debug("Stopping job processing...");
        TopologyCapabilities caps = this.topologyCapabilities;
        if (caps != null) {
            caps.deactivate();
            this.topologyCapabilities = null;
            this.notifyListeners();
        }
        this.logger.debug("Job processing stopped");
    }

    private void startProcessing(TopologyEvent.Type eventType, final TopologyCapabilities newCaps) {
        this.logger.debug("Starting job processing...");
        this.topologyCapabilities = newCaps;
        if (eventType == TopologyEvent.Type.TOPOLOGY_INIT) {
            UpgradeTask task = new UpgradeTask(this);
            task.run();
            FindUnfinishedJobsTask rt = new FindUnfinishedJobsTask(this);
            rt.run();
            CheckTopologyTask mt = new CheckTopologyTask(this);
            mt.fullRun();
            this.notifyListeners();
        } else {
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (newCaps == JobManagerConfiguration.this.topologyCapabilities && newCaps.isActive()) {
                        JobManagerConfiguration.this.notifyListeners();
                        if (newCaps.isLeader() && newCaps.isActive()) {
                            CheckTopologyTask mt = new CheckTopologyTask(JobManagerConfiguration.this);
                            mt.fullRun();
                        }
                    }
                }
            }, this.backgroundLoadDelay * 1000L);
        }
        this.logger.debug("Job processing started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        List<ConfigurationChangeListener> list = this.listeners;
        synchronized (list) {
            TopologyCapabilities caps = this.topologyCapabilities;
            for (ConfigurationChangeListener l : this.listeners) {
                l.configurationChanged(caps != null);
            }
        }
    }

    public void handleTopologyEvent(TopologyEvent event) {
        if (this.startupDelayListener != null) {
            this.startupDelayListener.handleTopologyEvent(event);
        } else {
            this.logger.debug("Received topology event {}", (Object)event);
            this.doHandleTopologyEvent(event);
        }
    }

    void doHandleTopologyEvent(TopologyEvent event) {
        TopologyEvent.Type eventType;
        boolean stopProcessing = true;
        if (event.getType() == TopologyEvent.Type.PROPERTIES_CHANGED) {
            Map<String, String> newAllInstances = TopologyCapabilities.getAllInstancesMap(event.getNewView());
            if (this.topologyCapabilities != null && this.topologyCapabilities.isSame(newAllInstances)) {
                this.logger.debug("No changes in capabilities - updating topology capabilities with new view");
                stopProcessing = false;
            }
        }
        if ((eventType = event.getType()) == TopologyEvent.Type.TOPOLOGY_CHANGING) {
            this.stopProcessing();
        } else if (eventType == TopologyEvent.Type.TOPOLOGY_INIT || event.getType() == TopologyEvent.Type.TOPOLOGY_CHANGED || event.getType() == TopologyEvent.Type.PROPERTIES_CHANGED) {
            if (stopProcessing) {
                this.stopProcessing();
            }
            this.startProcessing(eventType, new TopologyCapabilities(event.getNewView(), this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ConfigurationChangeListener service) {
        List<ConfigurationChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(service);
            service.configurationChanged(this.topologyCapabilities != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ConfigurationChangeListener service) {
        List<ConfigurationChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJobToRetryList(Job job) {
        Map<String, Job> map = this.retryList;
        synchronized (map) {
            this.retryList.put(job.getId(), job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Job> clearJobRetryList() {
        ArrayList<Job> result = new ArrayList<Job>();
        Map<String, Job> map = this.retryList;
        synchronized (map) {
            result.addAll(this.retryList.values());
            this.retryList.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeJobFromRetryList(Job job) {
        Map<String, Job> map = this.retryList;
        synchronized (map) {
            return this.retryList.remove(job.getId()) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job getJobFromRetryList(String jobId) {
        Map<String, Job> map = this.retryList;
        synchronized (map) {
            return this.retryList.get(jobId);
        }
    }

    public Logger getAuditLogger() {
        return this.auditLogger;
    }

    @ObjectClassDefinition(name="Apache Sling Job Manager", description="This is the central service of the job handling.")
    public static @interface Config {
        @AttributeDefinition(name="Disable Distribution", description="If the distribution is disabled, all jobs will be processed on the leader only! Please use this switch with care.")
        public boolean job_consumermanager_disableDistribution() default false;

        @AttributeDefinition(name="Startup Delay", description="Specify amount in seconds that job manager waits on startup before starting with job handling. This can be used to allow enough time to restart a cluster before jobs are eventually reassigned.")
        public long startup_delay() default 30L;

        @AttributeDefinition(name="Clean-up removed jobs period", description="Specify the periodic interval in minutes (default is 48h - use 0 to disable) after which removed jobs (ERROR or DROPPED) should be cleaned from the repository.")
        public int cleanup_period() default 2880;

        @AttributeDefinition(name="Progress Log message's max count", description="Max number of log messages that can stored by consumer to add information about current state of Job.\nAny attempt to add more information would result into purging of the least recent messages.Use 0 to discard all the logs. default is -1 (to indicate infinite). ")
        public int progresslog_maxCount() default -1;
    }
}

