/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.console;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.request.ResponseUtil;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.event.impl.jobs.JobConsumerManager;
import org.apache.sling.event.impl.jobs.config.InternalQueueConfiguration;
import org.apache.sling.event.impl.jobs.config.JobManagerConfiguration;
import org.apache.sling.event.impl.jobs.config.TopologyCapabilities;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.Queue;
import org.apache.sling.event.jobs.QueueConfiguration;
import org.apache.sling.event.jobs.ScheduleInfo;
import org.apache.sling.event.jobs.ScheduledJobInfo;
import org.apache.sling.event.jobs.Statistics;
import org.apache.sling.event.jobs.TopicStatistics;
import org.apache.sling.event.jobs.consumer.JobConsumer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class, JobConsumer.class}, property={"service.vendor=The Apache Software Foundation", "felix.webconsole.label=slingevent", "felix.webconsole.title=Jobs", "felix.webconsole.category=Sling", "job.topics=sling/webconsole/test"})
public class WebConsolePlugin
extends HttpServlet
implements JobConsumer {
    private static final String SLING_WEBCONSOLE_TEST_JOB_TOPIC = "sling/webconsole/test";
    private static final long serialVersionUID = -6983227434841706385L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private JobManager jobManager;
    @Reference
    private JobManagerConfiguration configuration;
    @Reference
    private JobConsumerManager jobConsumerManager;
    private static final String PAR_QUEUE = "queue";
    private final DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss:SSS yyyy-MMM-dd");

    private Queue getQueue(HttpServletRequest req) {
        String name = req.getParameter(PAR_QUEUE);
        if (name != null) {
            for (Queue q : this.jobManager.getQueues()) {
                if (!name.equals(q.getName())) continue;
                return q;
            }
        }
        return null;
    }

    private String getQueueErrorMessage(HttpServletRequest req, String command) {
        String name = req.getParameter(PAR_QUEUE);
        if (name == null || name.length() == 0) {
            return "Queue parameter missing for opertation " + command;
        }
        return "Queue with name '" + name + "' not found for operation " + command;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Queue q;
        String msg = null;
        String cmd = req.getParameter("action");
        if ("suspend".equals(cmd)) {
            q = this.getQueue(req);
            if (q != null) {
                q.suspend();
            } else {
                msg = this.getQueueErrorMessage(req, "suspend");
            }
        } else if ("resume".equals(cmd)) {
            q = this.getQueue(req);
            if (q != null) {
                q.resume();
            } else {
                msg = this.getQueueErrorMessage(req, "resume");
            }
        } else if ("reset".equals(cmd)) {
            if (req.getParameter(PAR_QUEUE) == null || req.getParameter(PAR_QUEUE).length() == 0) {
                this.jobManager.getStatistics().reset();
            } else {
                q = this.getQueue(req);
                if (q != null) {
                    q.getStatistics().reset();
                } else {
                    msg = this.getQueueErrorMessage(req, "reset");
                }
            }
        } else if ("test".equals(cmd)) {
            this.startTestJob();
        } else if ("dropall".equals(cmd)) {
            q = this.getQueue(req);
            if (q != null) {
                q.removeAll();
            } else {
                msg = this.getQueueErrorMessage(req, "drop all");
            }
        } else {
            msg = "Unknown command";
        }
        String path = req.getContextPath() + req.getServletPath() + req.getPathInfo();
        String redirectTo = msg == null ? path : path + "?message=" + URLEncoder.encode(msg, "UTF-8");
        resp.sendRedirect(resp.encodeRedirectURL(redirectTo));
    }

    private void startTestJob() {
        this.logger.info("Adding test job: {}", (Object)SLING_WEBCONSOLE_TEST_JOB_TOPIC);
        this.jobManager.addJob(SLING_WEBCONSOLE_TEST_JOB_TOPIC, null);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        InternalQueueConfiguration[] configs;
        String msg = req.getParameter("message");
        PrintWriter pw = res.getWriter();
        pw.println("<form method='POST' name='eventingcmd'><input type='hidden' name='action' value=''/><input type='hidden' name='queue' value=''/></form>");
        pw.println("<script type='text/javascript'>");
        pw.println("function eventingsubmit(action, queue) { document.forms['eventingcmd'].action.value = action; document.forms['eventingcmd'].queue.value = queue; document.forms['eventingcmd'].submit();} </script>");
        pw.printf("<p class='statline ui-state-highlight'>Apache Sling Job Handling%s%n</p>", msg != null ? " : " + ResponseUtil.escapeXml((String)msg) : "");
        pw.println("<div class='ui-widget-header ui-corner-top buttonGroup'>");
        pw.println("<span style='float: left; margin-left: 1em'>Apache Sling Job Handling: Overall Statistics</span>");
        this.printForm(pw, null, "Reset Stats", "reset");
        pw.println("</div>");
        pw.println("<table class='nicetable'><tbody>");
        String topics = this.jobConsumerManager.getTopics();
        if (topics == null) {
            topics = "";
        } else {
            String[] allTopics = topics.split(",");
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String t : allTopics) {
                if (first) {
                    first = false;
                } else {
                    sb.append("<br/>");
                }
                sb.append(ResponseUtil.escapeXml((String)t));
            }
            topics = sb.toString();
        }
        Statistics s = this.jobManager.getStatistics();
        pw.printf("<tr><td>Start Time</td><td>%s</td></tr>", this.formatDate(s.getStartTime()));
        pw.printf("<tr><td>Local topic consumers: </td><td>%s</td></tr>", topics);
        pw.printf("<tr><td>Last Activated</td><td>%s</td></tr>", this.formatDate(s.getLastActivatedJobTime()));
        pw.printf("<tr><td>Last Finished</td><td>%s</td></tr>", this.formatDate(s.getLastFinishedJobTime()));
        pw.printf("<tr><td>Queued Jobs</td><td>%s</td></tr>", s.getNumberOfQueuedJobs());
        pw.printf("<tr><td>Active Jobs</td><td>%s</td></tr>", s.getNumberOfActiveJobs());
        pw.printf("<tr><td>Jobs</td><td>%s</td></tr>", s.getNumberOfJobs());
        pw.printf("<tr><td>Finished Jobs</td><td>%s</td></tr>", s.getNumberOfFinishedJobs());
        pw.printf("<tr><td>Failed Jobs</td><td>%s</td></tr>", s.getNumberOfFailedJobs());
        pw.printf("<tr><td>Cancelled Jobs</td><td>%s</td></tr>", s.getNumberOfCancelledJobs());
        pw.printf("<tr><td>Processed Jobs</td><td>%s</td></tr>", s.getNumberOfProcessedJobs());
        pw.printf("<tr><td>Average Processing Time</td><td>%s</td></tr>", this.formatTime(s.getAverageProcessingTime()));
        pw.printf("<tr><td>Average Waiting Time</td><td>%s</td></tr>", this.formatTime(s.getAverageWaitingTime()));
        pw.println("</tbody></table>");
        pw.println("<br/>");
        pw.println("<table class='nicetable'><tbody>");
        pw.println("<tr><th colspan='2'>Topology Capabilities</th></tr>");
        TopologyCapabilities cap = this.configuration.getTopologyCapabilities();
        if (cap == null) {
            pw.print("<tr><td colspan='2'>No topology information available !</td></tr>");
        } else {
            Map<String, List<InstanceDescription>> instanceCaps = cap.getInstanceCapabilities();
            for (Map.Entry<String, List<InstanceDescription>> entry : instanceCaps.entrySet()) {
                StringBuilder sb = new StringBuilder();
                for (InstanceDescription id : entry.getValue()) {
                    if (sb.length() > 0) {
                        sb.append("<br/>");
                    }
                    if (id.isLocal()) {
                        sb.append("<b>local</b>");
                        continue;
                    }
                    sb.append(ResponseUtil.escapeXml((String)id.getSlingId()));
                }
                pw.printf("<tr><td>%s</td><td>%s</td></tr>", ResponseUtil.escapeXml((String)entry.getKey()), sb.toString());
            }
        }
        pw.println("</tbody></table>");
        pw.println("<br/>");
        pw.println("<p class='statline'>Scheduled Jobs</p>");
        pw.println("<table class='nicetable'><tbody>");
        Collection<ScheduledJobInfo> infos = this.jobManager.getScheduledJobs();
        if (infos.size() == 0) {
            pw.print("<tr><td colspan='5'>No jobs currently scheduled.</td></tr>");
        } else {
            pw.println("<tr><th>Schedule</th><th>Job Topic</th><th>Schedules</th></tr>");
            int index = 1;
            for (ScheduledJobInfo info : infos) {
                pw.printf("<tr><td><b>%s</b></td><td>%s</td><td>", String.valueOf(index), ResponseUtil.escapeXml((String)info.getJobTopic()));
                boolean first = true;
                block12: for (ScheduleInfo si : info.getSchedules()) {
                    if (!first) {
                        pw.print("<br/>");
                    }
                    first = false;
                    switch (si.getType()) {
                        case YEARLY: {
                            pw.printf("YEARLY %s %s : %s:%s", si.getMonthOfYear(), si.getDayOfMonth(), si.getHourOfDay(), si.getMinuteOfHour());
                            continue block12;
                        }
                        case MONTHLY: {
                            pw.printf("MONTHLY %s : %s:%s", si.getDayOfMonth(), si.getHourOfDay(), si.getMinuteOfHour());
                            continue block12;
                        }
                        case WEEKLY: {
                            pw.printf("WEEKLY %s : %s:%s", si.getDayOfWeek(), si.getHourOfDay(), si.getMinuteOfHour());
                            continue block12;
                        }
                        case DAILY: {
                            pw.printf("DAILY %s:%s", si.getHourOfDay(), si.getMinuteOfHour());
                            continue block12;
                        }
                        case HOURLY: {
                            pw.printf("HOURLY %s", si.getMinuteOfHour());
                            continue block12;
                        }
                        case CRON: {
                            pw.printf("CRON %s", ResponseUtil.escapeXml((String)si.getExpression()));
                            continue block12;
                        }
                    }
                    pw.printf("AT %s", si.getAt());
                }
                pw.print("</td></tr>");
                ++index;
            }
        }
        pw.println("</tbody></table>");
        pw.println("<br/>");
        boolean isEmpty = true;
        for (Queue q : this.jobManager.getQueues()) {
            isEmpty = false;
            String queueName = q.getName();
            pw.println("<div class='ui-widget-header ui-corner-top buttonGroup'>");
            pw.printf("<span style='float: left; margin-left: 1em'>Active JobQueue: %s %s</span>", ResponseUtil.escapeXml((String)queueName), q.isSuspended() ? "(SUSPENDED)" : "");
            this.printForm(pw, queueName, "Reset Stats", "reset");
            if (q.isSuspended()) {
                this.printForm(pw, queueName, "Resume", "resume");
            } else {
                this.printForm(pw, queueName, "Suspend", "suspend");
            }
            this.printForm(pw, queueName, "Test", "test");
            this.printForm(pw, queueName, "Drop All", "dropall");
            pw.println("</div>");
            pw.println("<table class='nicetable'><tbody>");
            s = q.getStatistics();
            QueueConfiguration c = q.getConfiguration();
            pw.println("<tr><th colspan='2'>Statistics</th><th colspan='2'>Configuration</th></tr>");
            pw.printf("<tr><td>Start Time</td><td>%s</td><td>Type</td><td>%s</td></tr>", this.formatDate(s.getStartTime()), this.formatType(c.getType()));
            pw.printf("<tr><td>Last Activated</td><td>%s</td><td>Topics</td><td>%s</td></tr>", this.formatDate(s.getLastActivatedJobTime()), this.formatArray(c.getTopics()));
            pw.printf("<tr><td>Last Finished</td><td>%s</td><td>Max Parallel</td><td>%s</td></tr>", this.formatDate(s.getLastFinishedJobTime()), c.getMaxParallel());
            pw.printf("<tr><td>Queued Jobs</td><td>%s</td><td>Max Retries</td><td>%s</td></tr>", s.getNumberOfQueuedJobs(), c.getMaxRetries());
            pw.printf("<tr><td>Active Jobs</td><td>%s</td><td>Retry Delay</td><td>%s ms</td></tr>", s.getNumberOfActiveJobs(), c.getRetryDelayInMs());
            pw.printf("<tr><td>Jobs</td><td>%s</td><td>Priority</td><td>%s</td></tr>", new Object[]{s.getNumberOfJobs(), c.getThreadPriority()});
            pw.printf("<tr><td>Finished Jobs</td><td>%s</td><td colspan='2'>&nbsp</td></tr>", s.getNumberOfFinishedJobs());
            pw.printf("<tr><td>Failed Jobs</td><td>%s</td><td colspan='2'>&nbsp</td></tr>", s.getNumberOfFailedJobs());
            pw.printf("<tr><td>Cancelled Jobs</td><td>%s</td><td colspan='2'>&nbsp</td></tr>", s.getNumberOfCancelledJobs());
            pw.printf("<tr><td>Processed Jobs</td><td>%s</td><td colspan='2'>&nbsp</td></tr>", s.getNumberOfProcessedJobs());
            pw.printf("<tr><td>Average Processing Time</td><td>%s</td><td colspan='2'>&nbsp</td></tr>", this.formatTime(s.getAverageProcessingTime()));
            pw.printf("<tr><td>Average Waiting Time</td><td>%s</td><td colspan='2'>&nbsp</td></tr>", this.formatTime(s.getAverageWaitingTime()));
            pw.printf("<tr><td>Status Info</td><td colspan='3'>%s</td></tr>", ResponseUtil.escapeXml((String)q.getStateInfo()));
            pw.println("</tbody></table>");
            pw.println("<br/>");
        }
        if (isEmpty) {
            pw.println("<p>No active queues.</p>");
            pw.println("<br/>");
        }
        for (TopicStatistics ts : this.jobManager.getTopicStatistics()) {
            pw.println("<table class='nicetable'><tbody>");
            pw.printf("<tr><th colspan='2'>Topic Statistics: %s</th></tr>", ResponseUtil.escapeXml((String)ts.getTopic()));
            pw.printf("<tr><td>Last Activated</td><td>%s</td></tr>", this.formatDate(ts.getLastActivatedJobTime()));
            pw.printf("<tr><td>Last Finished</td><td>%s</td></tr>", this.formatDate(ts.getLastFinishedJobTime()));
            pw.printf("<tr><td>Finished Jobs</td><td>%s</td></tr>", ts.getNumberOfFinishedJobs());
            pw.printf("<tr><td>Failed Jobs</td><td>%s</td></tr>", ts.getNumberOfFailedJobs());
            pw.printf("<tr><td>Cancelled Jobs</td><td>%s</td></tr>", ts.getNumberOfCancelledJobs());
            pw.printf("<tr><td>Processed Jobs</td><td>%s</td></tr>", ts.getNumberOfProcessedJobs());
            pw.printf("<tr><td>Average Processing Time</td><td>%s</td></tr>", this.formatTime(ts.getAverageProcessingTime()));
            pw.printf("<tr><td>Average Waiting Time</td><td>%s</td></tr>", this.formatTime(ts.getAverageWaitingTime()));
            pw.println("</tbody></table>");
            pw.println("<br/>");
        }
        pw.println("<p class='statline'>Apache Sling Job Handling - Job Queue Configurations</p>");
        this.printQueueConfiguration(req, pw, this.configuration.getQueueConfigurationManager().getMainQueueConfiguration());
        for (InternalQueueConfiguration c : configs = this.configuration.getQueueConfigurationManager().getConfigurations()) {
            this.printQueueConfiguration(req, pw, c);
        }
    }

    private void printQueueConfiguration(HttpServletRequest req, PrintWriter pw, InternalQueueConfiguration c) {
        pw.println("<div class='ui-widget-header ui-corner-top buttonGroup'>");
        pw.printf("<span style='float: left; margin-left: 1em'>Job Queue Configuration: %s</span>%n", ResponseUtil.escapeXml((String)c.getName()));
        pw.printf("<button id='edit' class='ui-state-default ui-corner-all' onclick='javascript:window.location=\"%s%s/configMgr/%s\";'>Edit</button>", req.getContextPath(), req.getServletPath(), c.getPid());
        this.printForm(pw, c.getName(), "Test", "test");
        pw.println("</div>");
        pw.println("<table class='nicetable'><tbody>");
        pw.println("<tr><th colspan='2'>Configuration</th></tr>");
        pw.printf("<tr><td>Valid</td><td>%s</td></tr>", c.isValid());
        pw.printf("<tr><td>Type</td><td>%s</td></tr>", this.formatType(c.getType()));
        pw.printf("<tr><td>Topics</td><td>%s</td></tr>", this.formatArray(c.getTopics()));
        pw.printf("<tr><td>Max Parallel</td><td>%s</td></tr>", c.getMaxParallel());
        pw.printf("<tr><td>Max Retries</td><td>%s</td></tr>", c.getMaxRetries());
        pw.printf("<tr><td>Retry Delay</td><td>%s ms</td></tr>", c.getRetryDelayInMs());
        pw.printf("<tr><td>Priority</td><td>%s</td></tr>", new Object[]{c.getThreadPriority()});
        pw.printf("<tr><td>Ranking</td><td>%s</td></tr>", c.getRanking());
        pw.println("</tbody></table>");
        pw.println("<br/>");
    }

    private String formatArray(String[] array) {
        if (array == null || array.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : array) {
            if (!first) {
                sb.append('\n');
            }
            first = false;
            sb.append(s);
        }
        return ResponseUtil.escapeXml((String)sb.toString());
    }

    private String formatType(QueueConfiguration.Type type) {
        switch (type) {
            case ORDERED: {
                return "Ordered";
            }
            case TOPIC_ROUND_ROBIN: {
                return "Topic Round Robin";
            }
            case UNORDERED: {
                return "Parallel";
            }
        }
        return type.toString();
    }

    private synchronized String formatDate(long time) {
        if (time == -1L) {
            return "-";
        }
        Date d = new Date(time);
        return this.dateFormat.format(d);
    }

    private String formatTime(long time) {
        if (time == 0L) {
            return "-";
        }
        if (time < 1000L) {
            return time + " ms";
        }
        if (time < 60000L) {
            return time / 1000L + " secs";
        }
        long min = time / 1000L / 60L;
        long secs = time - min * 1000L * 60L;
        return min + " min " + secs / 1000L + " secs";
    }

    private void printForm(PrintWriter pw, String qeueName, String buttonLabel, String cmd) {
        pw.printf("<button class='ui-state-default ui-corner-all' onclick='javascript:eventingsubmit(\"%s\", \"%s\");'>%s</button>", ResponseUtil.escapeXml((String)cmd), qeueName != null ? ResponseUtil.escapeXml((String)qeueName) : "", ResponseUtil.escapeXml((String)buttonLabel));
    }

    @Override
    public JobConsumer.JobResult process(Job job) {
        this.logger.info("Received test job {}", (Object)job.getTopic());
        return JobConsumer.JobResult.OK;
    }
}

