/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.console;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.request.ResponseUtil;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.engine.impl.SlingMainServlet;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.propertytypes.ServiceDescription;
import org.osgi.service.component.propertytypes.ServiceVendor;

@Component(service={Servlet.class}, configurationPid={"org.apache.sling.engine.impl.SlingMainServlet"}, property={"felix.webconsole.label=requests", "felix.webconsole.title=Recent requests", "felix.webconsole.category=Sling"})
@ServiceDescription(value="Web Console Plugin to display information about recent Sling requests")
@ServiceVendor(value="The Apache Software Foundation")
public class RequestHistoryConsolePlugin
extends HttpServlet {
    private static final long serialVersionUID = -5738101314957623511L;
    public static final String LABEL = "requests";
    public static final String INDEX = "index";
    public static final String CLEAR = "clear";
    private static volatile RequestHistoryConsolePlugin instance;
    public static final int STORED_REQUESTS_COUNT = 20;
    private volatile RequestInfoMap requests;
    private volatile List<Pattern> storePatterns = Collections.emptyList();

    @Activate
    public RequestHistoryConsolePlugin(SlingMainServlet.Config config) {
        this.update(config);
        instance = this;
    }

    @Modified
    protected void update(SlingMainServlet.Config config) {
        this.requests = config.sling_max_record_requests() > 0 ? new RequestInfoMap(config.sling_max_record_requests()) : null;
        ArrayList<Pattern> compiledPatterns = new ArrayList<Pattern>();
        if (config.sling_store_pattern_requests() != null) {
            for (String pattern : config.sling_store_pattern_requests()) {
                if (pattern == null || pattern.trim().length() <= 0) continue;
                compiledPatterns.add(Pattern.compile(pattern));
            }
        }
        this.storePatterns = compiledPatterns;
    }

    @Deactivate
    protected void deactivate() {
        instance = null;
        this.clear();
    }

    public static void recordRequest(SlingHttpServletRequest r) {
        RequestHistoryConsolePlugin local = instance;
        if (local != null) {
            local.addRequest(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRequest(SlingHttpServletRequest r) {
        RequestInfoMap local = this.requests;
        if (local != null) {
            String requestPath = r.getPathInfo();
            boolean accept = true;
            List<Pattern> patterns = this.storePatterns;
            if (!patterns.isEmpty()) {
                accept = false;
                for (Pattern pattern : patterns) {
                    if (!pattern.matcher(requestPath).matches()) continue;
                    accept = true;
                    break;
                }
            }
            if (accept) {
                RequestInfo info = new RequestInfo(r);
                RequestInfoMap requestInfoMap = local;
                synchronized (requestInfoMap) {
                    local.put(info.getKey(), info);
                }
            }
        }
    }

    private void clear() {
        RequestInfoMap local = this.requests;
        if (local != null) {
            local.clear();
        }
    }

    private void printLinksTable(PrintWriter pw, List<RequestInfo> values, String currentRequestIndex) {
        ArrayList<String> links = new ArrayList<String>();
        if (values != null) {
            for (RequestInfo info : values) {
                String key = ResponseUtil.escapeXml((String)info.getKey());
                boolean isCurrent = info.getKey().equals(currentRequestIndex);
                StringBuilder sb = new StringBuilder();
                sb.append("<span style='white-space: pre; text-align:right; font-size:80%'>");
                sb.append(String.format("%1$8s", key));
                sb.append("</span> ");
                sb.append("<a href='requests?index=" + key + "'>");
                if (isCurrent) {
                    sb.append("<b>");
                }
                sb.append(ResponseUtil.escapeXml((String)info.getLabel()));
                if (isCurrent) {
                    sb.append("</b>");
                }
                sb.append("</a> ");
                links.add(sb.toString());
            }
        }
        int nCols = 5;
        while (links.size() % 5 != 0) {
            links.add("&nbsp;");
        }
        pw.println("<table class='nicetable ui-widget'>");
        pw.println("<tr>\n");
        if (values.isEmpty()) {
            pw.print("No Requests recorded");
        } else {
            int i = 0;
            for (String str : links) {
                if (i++ % 5 == 0) {
                    pw.println("</tr>");
                    pw.println("<tr>");
                }
                pw.print("<td>");
                pw.print(str);
                pw.println("</td>");
            }
        }
        pw.println("</tr>");
        pw.println("</table>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ArrayList<RequestInfo> values;
        RequestInfoMap local = this.requests;
        String key = req.getParameter(INDEX);
        RequestInfo info = null;
        if (local != null) {
            RequestInfoMap requestInfoMap = local;
            synchronized (requestInfoMap) {
                values = new ArrayList<RequestInfo>(local.values());
                if (key != null) {
                    info = (RequestInfo)local.get(key);
                }
            }
        } else {
            values = null;
        }
        PrintWriter pw = resp.getWriter();
        if (local != null) {
            pw.println("<p class='statline ui-state-highlight'>Recorded " + values.size() + " requests (max: " + local.getMaxSize() + ")</p>");
        } else {
            pw.println("<p class='statline ui-state-highlight'>Request Recording disabled</p>");
        }
        pw.println("<div class='ui-widget-header ui-corner-top buttonGroup'>");
        pw.println("<span style='float: left; margin-left: 1em'>Recent Requests</span>");
        pw.println("<form method='POST'><input type='hidden' name='clear' value='clear'><input type='submit' value='Clear' class='ui-state-default ui-corner-all'></form>");
        pw.println("</div>");
        this.printLinksTable(pw, values, key);
        pw.println("<br/>");
        if (info != null) {
            pw.println("<table class='nicetable ui-widget'>");
            pw.println("<thead>");
            pw.println("<tr>");
            pw.printf("<th class='ui-widget-header'>Request %s (%s %s) by %s - RequestProgressTracker Info</th>%n", key, ResponseUtil.escapeXml((String)info.getMethod()), ResponseUtil.escapeXml((String)info.getPathInfo()), ResponseUtil.escapeXml((String)info.getUser()));
            pw.println("</tr>");
            pw.println("</thead>");
            pw.println("<tbody>");
            pw.println("<tr><td>");
            Iterator it = info.getTracker().getMessages();
            pw.print("<pre>");
            while (it.hasNext()) {
                pw.print(ResponseUtil.escapeXml((String)((String)it.next())));
            }
            pw.println("</pre></td></tr>");
            pw.println("</tbody></table>");
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getParameter(CLEAR) != null) {
            this.clear();
            resp.sendRedirect(req.getRequestURI());
        }
    }

    private static class RequestInfoMap
    extends LinkedHashMap<String, RequestInfo> {
        private static final long serialVersionUID = 4120391774146501524L;
        private int maxSize;

        RequestInfoMap(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, RequestInfo> eldest) {
            return this.size() > this.maxSize;
        }

        public int getMaxSize() {
            return this.maxSize;
        }
    }

    private static class RequestInfo {
        private static AtomicLong requestCounter = new AtomicLong(0L);
        private final String key = String.valueOf(requestCounter.incrementAndGet());
        private final String method;
        private final String pathInfo;
        private final String user;
        private final RequestProgressTracker tracker;

        RequestInfo(SlingHttpServletRequest request) {
            this.method = request.getMethod();
            this.pathInfo = request.getPathInfo();
            this.user = request.getRemoteUser();
            this.tracker = request.getRequestProgressTracker();
        }

        public String getKey() {
            return this.key;
        }

        public String getMethod() {
            return this.method;
        }

        public String getPathInfo() {
            return this.pathInfo;
        }

        public String getUser() {
            return this.user;
        }

        public String getLabel() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getMethod());
            sb.append(' ');
            String path = this.getPathInfo();
            if (path != null && path.length() > 0) {
                sb.append(ResourceUtil.getName((String)this.getPathInfo()));
            } else {
                sb.append('/');
            }
            return sb.toString();
        }

        public RequestProgressTracker getTracker() {
            return this.tracker;
        }
    }
}

