/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.console;

import java.io.PrintWriter;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.engine.impl.filter.FilterHandle;
import org.apache.sling.engine.impl.filter.ServletFilterManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class WebConsoleConfigPrinter {
    private final ServletFilterManager filterManager;

    public WebConsoleConfigPrinter(ServletFilterManager filterManager) {
        this.filterManager = filterManager;
    }

    public static ServiceRegistration register(BundleContext bundleContext, ServletFilterManager filterManager) {
        WebConsoleConfigPrinter filterPrinter = new WebConsoleConfigPrinter(filterManager);
        Hashtable<String, String> serviceProps = new Hashtable<String, String>();
        ((Dictionary)serviceProps).put("service.description", "Apache Sling Servlet Filter Configuration Printer");
        ((Dictionary)serviceProps).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)serviceProps).put("felix.webconsole.label", "slingfilter");
        ((Dictionary)serviceProps).put("felix.webconsole.title", "Sling Servlet Filter");
        ((Dictionary)serviceProps).put("felix.webconsole.configprinter.modes", "always");
        return bundleContext.registerService(WebConsoleConfigPrinter.class.getName(), (Object)filterPrinter, serviceProps);
    }

    public static void unregister(ServiceRegistration reg) {
        if (reg != null) {
            reg.unregister();
        }
    }

    private void printFilterChain(PrintWriter pw, FilterHandle[] entries) {
        if (entries == null) {
            pw.println("---");
        } else {
            for (FilterHandle entry : entries) {
                pw.printf("%d : %s (id: %d, property: %s); called: %d; time: %dms; time/call: %d\u00b5s%n", entry.getOrder(), entry.getFilter().getClass(), entry.getFilterId(), entry.getOrderSource(), entry.getCalls(), entry.getTime(), entry.getTimePerCall());
            }
        }
    }

    public void printConfiguration(PrintWriter pw) {
        pw.println("Current Apache Sling Servlet Filter Configuration");
        for (ServletFilterManager.FilterChainType type : ServletFilterManager.FilterChainType.values()) {
            pw.println();
            pw.println((Object)((Object)type) + " Filters:");
            this.printFilterChain(pw, this.filterManager.getFilterChain(type).getFilters());
        }
    }
}

