/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.request;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.engine.impl.request.ContentData;
import org.apache.sling.engine.impl.request.RequestData;
import org.apache.sling.engine.impl.request.SlingRequestPathInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingRequestDispatcher
implements RequestDispatcher {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Resource resource;
    private RequestDispatcherOptions options;
    private String path;

    public SlingRequestDispatcher(String path, RequestDispatcherOptions options) {
        this.path = path;
        this.options = options;
        this.resource = null;
    }

    public SlingRequestDispatcher(Resource resource, RequestDispatcherOptions options) {
        this.resource = resource;
        this.options = options;
        this.path = resource.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(ServletRequest request, ServletResponse sResponse) throws ServletException, IOException {
        ContentData cd;
        try {
            cd = RequestData.getRequestData(request).getContentData();
        }
        catch (IllegalArgumentException iae) {
            throw new ServletException(iae.getMessage());
        }
        HttpServletRequest hRequest = (HttpServletRequest)request;
        Object v1 = this.setAttribute(request, "org.apache.sling.api.include.resource", cd.getResource());
        Object v2 = this.setAttribute(request, "org.apache.sling.api.include.servlet", cd.getServlet());
        Object v3 = this.setAttribute(request, "org.apache.sling.api.include.request_path_info", cd.getRequestPathInfo());
        Object v4 = this.setAttribute(request, "javax.servlet.include.context_path", hRequest.getContextPath());
        Object v5 = this.setAttribute(request, "javax.servlet.include.path_info", hRequest.getPathInfo());
        Object v6 = this.setAttribute(request, "javax.servlet.include.query_string", hRequest.getQueryString());
        Object v7 = this.setAttribute(request, "javax.servlet.include.request_uri", hRequest.getRequestURI());
        Object v8 = this.setAttribute(request, "javax.servlet.include.servlet_path", hRequest.getServletPath());
        try {
            this.dispatch(request, sResponse, true);
        }
        finally {
            request.setAttribute("org.apache.sling.api.include.resource", v1);
            request.setAttribute("org.apache.sling.api.include.servlet", v2);
            request.setAttribute("org.apache.sling.api.include.request_path_info", v3);
            request.setAttribute("javax.servlet.include.context_path", v4);
            request.setAttribute("javax.servlet.include.path_info", v5);
            request.setAttribute("javax.servlet.include.query_string", v6);
            request.setAttribute("javax.servlet.include.request_uri", v7);
            request.setAttribute("javax.servlet.include.servlet_path", v8);
        }
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (response.isCommitted()) {
            throw new IllegalStateException("Response already committed");
        }
        response.resetBuffer();
        request.removeAttribute("org.apache.sling.api.include.resource");
        request.removeAttribute("org.apache.sling.api.include.servlet");
        request.removeAttribute("org.apache.sling.api.include.request_path_info");
        request.removeAttribute("javax.servlet.include.context_path");
        request.removeAttribute("javax.servlet.include.path_info");
        request.removeAttribute("javax.servlet.include.query_string");
        request.removeAttribute("javax.servlet.include.request_uri");
        request.removeAttribute("javax.servlet.include.servlet_path");
        this.dispatch(request, response, false);
        response.flushBuffer();
    }

    private String getAbsolutePath(SlingHttpServletRequest request, String path) {
        if (path.startsWith("/")) {
            return path;
        }
        String uri = request.getResource().getPath();
        int lastSlash = uri.lastIndexOf(47);
        if (lastSlash >= 0) {
            uri = uri.substring(0, lastSlash);
        }
        return uri + '/' + path;
    }

    private void dispatch(ServletRequest request, ServletResponse sResponse, boolean include) throws ServletException, IOException {
        SlingHttpServletRequest cRequest = RequestData.unwrap(request);
        RequestData rd = RequestData.getRequestData(cRequest);
        String absPath = this.getAbsolutePath(cRequest, this.path);
        RequestProgressTracker requestProgressTracker = cRequest.getRequestProgressTracker();
        if (!(sResponse instanceof HttpServletResponse)) {
            this.log.error("include: Failed to include {}, response has wrong type", (Object)absPath);
            return;
        }
        if (this.resource == null) {
            String timerName = "resolveIncludedResource(" + absPath + ")";
            requestProgressTracker.startTimer(timerName);
            this.resource = cRequest.getResourceResolver().resolve(absPath);
            if (this.resource == null) {
                this.log.error("include: Could not resolve {} to a resource, not including", (Object)absPath);
                return;
            }
            requestProgressTracker.logTimer(timerName, "path={0} resolves to Resource={1}", new Object[]{absPath, this.resource});
        }
        SlingRequestPathInfo info = this.getMergedRequestPathInfo(cRequest);
        requestProgressTracker.log("Including resource {0} ({1})", new Object[]{this.resource, info});
        rd.getSlingRequestProcessor().dispatchRequest(request, sResponse, this.resource, info, include);
    }

    private SlingRequestPathInfo getMergedRequestPathInfo(SlingHttpServletRequest cRequest) {
        SlingRequestPathInfo info = new SlingRequestPathInfo(this.resource);
        info = info.merge(cRequest.getRequestPathInfo());
        if (this.options != null) {
            info = info.merge(this.options);
            String rtOverwrite = this.options.getForceResourceType();
            if (rtOverwrite != null && !rtOverwrite.equals(this.resource.getResourceType())) {
                this.resource = new TypeOverwritingResourceWrapper(this.resource, rtOverwrite);
            }
        }
        return info;
    }

    private Object setAttribute(ServletRequest request, String name, Object value) {
        Object oldValue = request.getAttribute(name);
        request.setAttribute(name, value);
        return oldValue;
    }

    private static class TypeOverwritingResourceWrapper
    extends ResourceWrapper {
        private final String resourceType;

        TypeOverwritingResourceWrapper(Resource delegatee, String resourceType) {
            super(delegatee);
            this.resourceType = resourceType;
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public String getResourceSuperType() {
            return null;
        }

        public boolean isResourceType(String resourceType) {
            return this.getResourceResolver().isResourceType((Resource)this, resourceType);
        }
    }
}

