/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.log;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.engine.impl.log.RequestLoggerService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;

@Component(property={"service.description=Request Logger", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=Config.class)
public class RequestLogger {
    private static final String REQUEST_LOG_ENTRY_FORMAT = "%t [%R] -> %m %U%q %H";
    private static final String REQUEST_LOG_EXIT_FORMAT = "%{end}t [%R] <- %s %{Content-Type}o %Dms";
    private static final String ACCESS_LOG_FORMAT = "%a %l %u %t \"%r\" %>s %b \"%{Referer}i\" \"%{User-Agent}i\"";
    private Map<ServiceRegistration, RequestLoggerService> services = new HashMap<ServiceRegistration, RequestLoggerService>();

    @Activate
    protected void activate(BundleContext bundleContext, Config config) {
        if (config.request_log_output() != null && config.request_log_enabled()) {
            RequestLogger.createRequestLoggerService(this.services, bundleContext, true, REQUEST_LOG_ENTRY_FORMAT, config.request_log_output(), config.request_log_outputtype());
            RequestLogger.createRequestLoggerService(this.services, bundleContext, false, REQUEST_LOG_EXIT_FORMAT, config.request_log_output(), config.request_log_outputtype());
        }
        if (config.access_log_output() != null && config.access_log_enabled()) {
            RequestLogger.createRequestLoggerService(this.services, bundleContext, false, ACCESS_LOG_FORMAT, config.access_log_output(), config.access_log_outputtype());
        }
    }

    @Deactivate
    protected void deactivate() {
        for (Map.Entry<ServiceRegistration, RequestLoggerService> entry : this.services.entrySet()) {
            entry.getKey().unregister();
            entry.getValue().shutdown();
        }
        this.services.clear();
    }

    private static void createRequestLoggerService(Map<ServiceRegistration, RequestLoggerService> services, BundleContext bundleContext, final boolean onEntry, final String format, final String output, final int outputType) {
        RequestLoggerService service = new RequestLoggerService(bundleContext, new RequestLoggerService.Config(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return RequestLoggerService.Config.class;
            }

            @Override
            public int request_log_service_outputtype() {
                return outputType;
            }

            @Override
            public String request_log_service_output() {
                return output;
            }

            @Override
            public boolean request_log_service_onentry() {
                return onEntry;
            }

            @Override
            public String request_log_service_format() {
                return format;
            }
        });
        ServiceRegistration reg = bundleContext.registerService(service.getClass().getName(), (Object)service, null);
        services.put(reg, service);
    }

    @ObjectClassDefinition(name="Apache Sling Request Logger", description="Configures the main loggers of the request logger, namely the request log and the access log. Further loggers may be configured by creating configurations for the Request Logger Service.")
    public static @interface Config {
        @AttributeDefinition(name="Request Log Name", description="Name of the destination for the request log. The request log logs the entry and exit of each request into and out of the system together with the entry time, exit time, time to process the request, a request counter as well as the final status code and response content type. In terms of Request Logger Service formats, request entry is logged with the format \"%t [%R] -> %m %U%q %H\" and request exit is logged with the format \"%{end}t [%R] <- %s %{Content-Type}o %Dms\".")
        public String request_log_output() default "logs/request.log";

        @AttributeDefinition(name="Request Log Type", description="Type of request log destination. Select \"Logger Name\" to write the access log to an SLF4J logger, \"File Name\" to write the access log to a file (relative paths resolved against sling.home) or \"RequestLog Service\" to use a named OSGi service registered with the service interface \"org.apache.sling.engine.RequestLog\" and a service property \"requestlog.name\" equal to the Logger Name setting.", options={@Option(label="Logger Name", value="0"), @Option(label="File Name", value="1"), @Option(label="RequestLog Service", value="2")})
        public int request_log_outputtype() default 0;

        @AttributeDefinition(name="Enable Request Log", description="Whether to enable Request logging or not.")
        public boolean request_log_enabled() default true;

        @AttributeDefinition(name="Access Log Name", description="Name of the destination for the request log. The access log writes an entry for each request as the request terminates using the NCSA extended/combined log format. In terms of Request Logger Service formats the access log is written with the format \"%h %l %u %t \"%r\" %>s %b \"%{Referer}i\" \"%{User-Agent}i\"\".")
        public String access_log_output() default "logs/access.log";

        @AttributeDefinition(name="Access Log Type", description="Type of access log destination. Select \"Logger Name\" to write the access log to an SLF4J logger, \"File Name\" to write the access log to a file (relative paths resolved against sling.home) or \"RequestLog Service\" to use a named OSGi service registered with the service interface \"org.apache.sling.engine.RequestLog\" and a service property \"requestlog.name\" equal to the Logger Name setting.", options={@Option(label="Logger Name", value="0"), @Option(label="File Name", value="1"), @Option(label="RequestLog Service", value="2")})
        public int access_log_outputtype() default 0;

        @AttributeDefinition(name="Enable Access Log", description="Whether to enable Access logging or not.")
        public boolean access_log_enabled() default true;
    }
}

