/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.api.request.SlingRequestEvent;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.auth.core.AuthenticationSupport;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.engine.SlingRequestProcessor;
import org.apache.sling.engine.impl.RequestProcessorMBeanImpl;
import org.apache.sling.engine.impl.SlingHttpContext;
import org.apache.sling.engine.impl.SlingRequestProcessorImpl;
import org.apache.sling.engine.impl.StaticResponseHeader;
import org.apache.sling.engine.impl.WebConsoleConfigPrinter;
import org.apache.sling.engine.impl.filter.ServletFilterManager;
import org.apache.sling.engine.impl.helper.ClientAbortException;
import org.apache.sling.engine.impl.helper.RequestListenerManager;
import org.apache.sling.engine.impl.helper.SlingServletContext;
import org.apache.sling.engine.impl.request.RequestData;
import org.apache.sling.engine.impl.request.RequestHistoryConsolePlugin;
import org.apache.sling.engine.jmx.RequestProcessorMBean;
import org.apache.sling.engine.servlets.ErrorHandler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.vendor=The Apache Software Foundation", "service.description=Sling Servlet"})
@Designate(ocd=Config.class)
public class SlingMainServlet
extends GenericServlet {
    private static final String DEPRECATED_ENCODING_PROPERTY = "sling.default.parameter.encoding";
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    private volatile AdapterManager adapterManager;
    private BundleContext bundleContext;
    private final Logger log = LoggerFactory.getLogger(SlingMainServlet.class);
    private static final String SLING_ROOT = "/";
    public static final String SERVLET_CONTEXT_NAME = "org.apache.sling";
    static String PRODUCT_NAME = "ApacheSling";
    private SlingServletContext slingServletContext;
    private String productInfo = PRODUCT_NAME;
    private String serverInfo = PRODUCT_NAME;
    private RequestListenerManager requestListenerManager;
    private boolean allowTrace;
    private Object printerRegistration;
    private SlingHttpContext slingHttpContext = new SlingHttpContext();
    private ServletFilterManager filterManager;
    private final SlingRequestProcessorImpl requestProcessor = new SlingRequestProcessorImpl();
    private ServiceRegistration<SlingRequestProcessor> requestProcessorRegistration;
    private ServiceRegistration<RequestProcessorMBean> requestProcessorMBeanRegistration;
    private ServiceRegistration<ServletContextHelper> contextRegistration;
    private ServiceRegistration<Servlet> servletRegistration;
    private String configuredServerInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest req, ServletResponse res) throws ServletException {
        if (req instanceof HttpServletRequest && res instanceof HttpServletResponse) {
            HttpServletRequest request = (HttpServletRequest)req;
            String threadName = this.setThreadName(request);
            this.requestListenerManager.sendEvent(request, SlingRequestEvent.EventType.EVENT_INIT);
            ResourceResolver resolver = null;
            try {
                if (!this.allowTrace && "TRACE".equals(request.getMethod())) {
                    HttpServletResponse response = (HttpServletResponse)res;
                    response.setStatus(405);
                    response.setHeader("Allow", "GET, HEAD, POST, PUT, DELETE, OPTIONS");
                    return;
                }
                Object resolverObject = request.getAttribute("org.apache.sling.auth.core.ResourceResolver");
                resolver = resolverObject instanceof ResourceResolver ? (ResourceResolver)resolverObject : null;
                this.requestProcessor.doProcessRequest(request, (HttpServletResponse)res, resolver);
            }
            catch (ClientAbortException cae) {
                this.log.debug("service: ClientAbortException, probable cause is client aborted request or network problem", (Throwable)cae);
            }
            catch (Throwable t) {
                this.log.error("service: Uncaught Problem handling the request", t);
            }
            finally {
                if (resolver != null) {
                    resolver.close();
                }
                this.requestListenerManager.sendEvent(request, SlingRequestEvent.EventType.EVENT_DESTROY);
                if (threadName != null) {
                    Thread.currentThread().setName(threadName);
                }
            }
        } else {
            throw new ServletException("Apache Sling must be run in an HTTP servlet environment.");
        }
    }

    private void setProductInfo(BundleContext bundleContext) {
        Dictionary props = bundleContext.getBundle().getHeaders();
        Version bundleVersion = Version.parseVersion((String)((String)props.get("Bundle-Version")));
        String productVersion = bundleVersion.getMajor() + "." + bundleVersion.getMinor();
        this.productInfo = PRODUCT_NAME + SLING_ROOT + productVersion;
        this.setServerInfo();
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    private void setServerInfo() {
        if (this.configuredServerInfo != null) {
            this.serverInfo = this.configuredServerInfo;
        } else {
            String containerProductInfo;
            if (this.getServletConfig() == null || this.getServletContext() == null) {
                containerProductInfo = "unregistered";
            } else {
                String containerInfo = this.getServletContext().getServerInfo();
                if (containerInfo != null && containerInfo.length() > 0) {
                    int lbrace = containerInfo.indexOf(40);
                    if (lbrace < 0) {
                        lbrace = containerInfo.length();
                    }
                    containerProductInfo = containerInfo.substring(0, lbrace).trim();
                } else {
                    containerProductInfo = "unknown";
                }
            }
            this.serverInfo = String.format("%s (%s, %s %s, %s %s %s)", this.productInfo, containerProductInfo, System.getProperty("java.vm.name"), System.getProperty("java.version"), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
        }
        if (this.requestProcessor != null) {
            this.requestProcessor.setServerInfo(this.serverInfo);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> componentConfig, Config config) {
        this.bundleContext = bundleContext;
        String[] props = config.sling_additional_response_headers();
        if (props != null) {
            ArrayList<StaticResponseHeader> mappings = new ArrayList<StaticResponseHeader>(props.length);
            for (String prop : props) {
                if (prop == null || prop.trim().length() <= 0) continue;
                try {
                    StaticResponseHeader mapping = new StaticResponseHeader(prop.trim());
                    mappings.add(mapping);
                }
                catch (IllegalArgumentException iae) {
                    this.log.info("configure: Ignoring '{}': {}", (Object)prop, (Object)iae.getMessage());
                }
            }
            RequestData.setAdditionalResponseHeaders(mappings);
        }
        this.configuredServerInfo = config.sling_serverinfo();
        this.setProductInfo(bundleContext);
        Hashtable<String, Object> configuration = new Hashtable<String, Object>(componentConfig);
        if (!(configuration.get("servlet-name") instanceof String)) {
            configuration.put("servlet-name", this.productInfo);
        }
        this.allowTrace = config.sling_trace_allow();
        RequestData.setMaxIncludeCounter(config.sling_max_inclusions());
        RequestData.setMaxCallCounter(config.sling_max_calls());
        RequestData.setSlingMainServlet(this);
        if (componentConfig.get(DEPRECATED_ENCODING_PROPERTY) != null) {
            this.log.warn("Please configure the default request parameter encoding using the 'org.apache.sling.engine.parameters' configuration PID; the property sling.default.parameter.encoding=" + componentConfig.get(DEPRECATED_ENCODING_PROPERTY) + " is obsolete and ignored");
        }
        Hashtable<String, String> contextProperties = new Hashtable<String, String>();
        ((Dictionary)contextProperties).put("osgi.http.whiteboard.context.name", SERVLET_CONTEXT_NAME);
        ((Dictionary)contextProperties).put("osgi.http.whiteboard.context.path", SLING_ROOT);
        ((Dictionary)contextProperties).put("service.description", "Apache Sling Engine Servlet Context Helper");
        ((Dictionary)contextProperties).put("service.vendor", "The Apache Software Foundation");
        this.contextRegistration = bundleContext.registerService(ServletContextHelper.class, (Object)this.slingHttpContext, contextProperties);
        Dictionary<String, String> servletConfig = this.toStringConfig(configuration);
        servletConfig.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=org.apache.sling)");
        servletConfig.put("osgi.http.whiteboard.servlet.pattern", SLING_ROOT);
        servletConfig.put("service.description", "Apache Sling Engine Main Servlet");
        servletConfig.put("service.vendor", "The Apache Software Foundation");
        this.servletRegistration = bundleContext.registerService(Servlet.class, (Object)this, servletConfig);
        try {
            int maxRequests = config.sling_max_record_requests();
            String[] patterns = config.sling_store_pattern_requests();
            if (patterns == null) {
                patterns = new String[]{};
            }
            ArrayList<Pattern> compiledPatterns = new ArrayList<Pattern>(patterns.length);
            for (String pattern : patterns) {
                if (pattern == null || pattern.trim().length() <= 0) continue;
                compiledPatterns.add(Pattern.compile(pattern));
            }
            RequestHistoryConsolePlugin.initPlugin(bundleContext, maxRequests, compiledPatterns);
        }
        catch (Throwable t) {
            this.log.debug("Unable to register web console request recorder plugin.", t);
        }
        try {
            Hashtable<String, String> mbeanProps = new Hashtable<String, String>();
            ((Dictionary)mbeanProps).put("jmx.objectname", "org.apache.sling:type=engine,service=RequestProcessor");
            RequestProcessorMBeanImpl mbean = new RequestProcessorMBeanImpl();
            this.requestProcessorMBeanRegistration = bundleContext.registerService(RequestProcessorMBean.class, (Object)mbean, mbeanProps);
            this.requestProcessor.setMBean(mbean);
        }
        catch (Throwable t) {
            this.log.debug("Unable to register mbean");
        }
        Hashtable<String, String> srpProps = new Hashtable<String, String>();
        srpProps.put("service.vendor", "The Apache Software Foundation");
        srpProps.put("service.description", "Sling Request Processor");
        this.requestProcessorRegistration = bundleContext.registerService(SlingRequestProcessor.class, (Object)this.requestProcessor, srpProps);
    }

    private void registerOnInit(BundleContext bundleContext) {
        this.slingServletContext = new SlingServletContext(bundleContext, this);
        this.filterManager = new ServletFilterManager(bundleContext, this.slingServletContext);
        this.filterManager.open();
        this.requestProcessor.setFilterManager(this.filterManager);
        this.requestListenerManager = new RequestListenerManager(bundleContext, this.slingServletContext);
        this.printerRegistration = WebConsoleConfigPrinter.register(bundleContext, this.filterManager);
    }

    public void init() {
        this.setServerInfo();
        this.log.info("{} ready to serve requests", (Object)this.getServerInfo());
        this.registerOnInit(this.bundleContext);
    }

    @Deactivate
    protected void deactivate() {
        if (this.requestProcessorRegistration != null) {
            this.requestProcessorRegistration.unregister();
            this.requestProcessorRegistration = null;
        }
        if (this.requestProcessorMBeanRegistration != null) {
            this.requestProcessorMBeanRegistration.unregister();
            this.requestProcessorMBeanRegistration = null;
        }
        try {
            RequestHistoryConsolePlugin.destroyPlugin();
        }
        catch (Throwable t) {
            this.log.debug("Problem unregistering web console request recorder plugin.", t);
        }
        if (this.printerRegistration != null) {
            WebConsoleConfigPrinter.unregister(this.printerRegistration);
            this.printerRegistration = null;
        }
        if (this.filterManager != null) {
            this.requestProcessor.setFilterManager(null);
            this.filterManager.close();
        }
        if (this.contextRegistration != null) {
            this.contextRegistration.unregister();
            this.contextRegistration = null;
        }
        if (this.slingServletContext != null) {
            this.slingServletContext.dispose();
            this.slingServletContext = null;
        }
        if (this.servletRegistration != null) {
            this.servletRegistration.unregister();
            this.servletRegistration = null;
        }
        if (this.requestListenerManager != null) {
            this.requestListenerManager.dispose();
            this.requestListenerManager = null;
        }
        RequestData.setSlingMainServlet(null);
        this.bundleContext = null;
        this.log.info(this.getServerInfo() + " shut down");
    }

    @Reference(name="ErrorHandler", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetErrorHandler")
    void setErrorHandler(ErrorHandler errorHandler) {
        this.requestProcessor.setErrorHandler(errorHandler);
    }

    void unsetErrorHandler(ErrorHandler errorHandler) {
        this.requestProcessor.unsetErrorHandler(errorHandler);
    }

    @Reference(name="ServletResolver", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetServletResolver")
    public void setServletResolver(ServletResolver servletResolver) {
        this.requestProcessor.setServletResolver(servletResolver);
    }

    public void unsetServletResolver(ServletResolver servletResolver) {
        this.requestProcessor.unsetServletResolver(servletResolver);
    }

    @Reference(name="MimeTypeService", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetMimeTypeService")
    public void setMimeTypeService(MimeTypeService mimeTypeService) {
        this.slingHttpContext.setMimeTypeService(mimeTypeService);
    }

    public void unsetMimeTypeService(MimeTypeService mimeTypeService) {
        this.slingHttpContext.unsetMimeTypeService(mimeTypeService);
    }

    @Reference(name="AuthenticationSupport", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetAuthenticationSupport")
    public void setAuthenticationSupport(AuthenticationSupport authenticationSupport) {
        this.slingHttpContext.setAuthenticationSupport(authenticationSupport);
    }

    public void unsetAuthenticationSupport(AuthenticationSupport authenticationSupport) {
        this.slingHttpContext.unsetAuthenticationSupport(authenticationSupport);
    }

    private Dictionary<String, String> toStringConfig(Dictionary<?, ?> config) {
        Hashtable<String, String> stringConfig = new Hashtable<String, String>();
        Enumeration<?> ke = config.keys();
        while (ke.hasMoreElements()) {
            Object key = ke.nextElement();
            ((Dictionary)stringConfig).put(key.toString(), String.valueOf(config.get(key)));
        }
        return stringConfig;
    }

    public String getMimeType(String name) {
        return this.slingHttpContext.getMimeType(name);
    }

    public <Type> Type adaptTo(Object object, Class<Type> type) {
        AdapterManager adapterManager = this.adapterManager;
        if (adapterManager != null) {
            return (Type)adapterManager.getAdapter(object, type);
        }
        return null;
    }

    private String setThreadName(HttpServletRequest request) {
        Thread thread = Thread.currentThread();
        String oldThreadName = thread.getName();
        StringBuilder buf = new StringBuilder();
        buf.append(request.getRemoteAddr());
        buf.append(" [").append(System.currentTimeMillis()).append("] ");
        buf.append(request.getMethod()).append(' ');
        buf.append(request.getRequestURI()).append(' ');
        buf.append(request.getProtocol());
        thread.setName(buf.toString());
        return oldThreadName;
    }

    @ObjectClassDefinition(name="Apache Sling Main Servlet", description="Main processor of the Sling framework controlling all aspects of processing requests inside of Sling, namely authentication, resource resolution, servlet/script resolution and execution of servlets and scripts.")
    public static @interface Config {
        @AttributeDefinition(name="Number of Calls per Request", description="Defines the maximum number of Servlet and Script calls while processing a single client request. This number should be high enough to not limit request processing artificially. On the other hand it should not be too high to allow the mechanism to limit the resources required to process a request in case of errors. The default value is 1000.")
        public int sling_max_calls() default 1000;

        @AttributeDefinition(name="Recursion Depth", description="The maximum number of recursive Servlet and Script calls while processing a single client request. This number should not be too high, otherwise StackOverflowErrors may occurr in case of erroneous scripts and servlets. The default value is 50. ")
        public int sling_max_inclusions() default 50;

        @AttributeDefinition(name="Allow the HTTP TRACE method", description="If set to true, the HTTP TRACE method will be enabled. By default the HTTP TRACE methods is disabled as it can be used in Cross Site Scripting attacks on HTTP servers.")
        public boolean sling_trace_allow() default false;

        @AttributeDefinition(name="Number of Requests to Record", description="Defines the number of requests that internally recorded for display on the \"Recent Requests\" Web Console page. If this value is less than or equal to zero, no requests are internally kept. The default value is 20. ")
        public int sling_max_record_requests() default 20;

        @AttributeDefinition(name="Recorded Request Path Patterns", description="One or more regular expressions which limit the requests which are stored by the \"Recent Requests\" Web Console page.")
        public String[] sling_store_pattern_requests();

        @AttributeDefinition(name="Server Info", description="The server info returned by Sling. If this field is left empty, Sling generates a default into.")
        public String sling_serverinfo();

        @AttributeDefinition(name="Additional response headers", description="Provides mappings for additional response headers Each entry is of the form 'bundleId [ \":\" responseHeaderName ] \"=\" responseHeaderValue'")
        public String[] sling_additional_response_headers() default {"X-Content-Type-Options=nosniff", "X-Frame-Options=SAMEORIGIN"};
    }
}

