/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.dynamicinclude;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.dynamicinclude.pathmatcher.PathMatcher;
import org.apache.sling.dynamicinclude.pathmatcher.PrefixPathMatcher;
import org.apache.sling.dynamicinclude.pathmatcher.RegexPathMatcher;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Configuration.class}, immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=The Apache Software Foundation", "webconsole.configurationFactory.nameHint={include-filter.config.include-type} for [{include-filter.config.resource-types}] at path: {include-filter.config.path}"})
@Designate(ocd=Config.class, factory=true)
public class Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(Configuration.class);
    private PathMatcher pathMatcher;
    private boolean isEnabled;
    private String includeSelector;
    private String extension;
    private int ttl;
    private List<String> resourceTypes;
    private boolean addComment;
    private String includeTypeName;
    private String requiredHeader;
    private boolean disableIgnoreUrlParams;
    private Collection<String> ignoreUrlParams;
    private boolean rewritePath;
    private boolean appendSuffix;

    @Activate
    public void activate(Config cfg) {
        this.isEnabled = cfg.include$_$filter_config_enabled();
        String pathPattern = cfg.include$_$filter_config_path();
        this.pathMatcher = this.choosePathMatcher(pathPattern);
        String[] resourceTypeList = PropertiesUtil.toStringArray((Object)cfg.include$_$filter_config_resource$_$types(), (String[])new String[0]);
        for (int i = 0; i < resourceTypeList.length; ++i) {
            String name;
            String[] s = resourceTypeList[i].split(";");
            resourceTypeList[i] = name = s[0].trim();
        }
        this.resourceTypes = Arrays.asList(resourceTypeList);
        this.includeSelector = cfg.include$_$filter_config_selector();
        this.extension = cfg.include$_$filter_config_extension();
        this.ttl = PropertiesUtil.toInteger((Object)cfg.include$_$filter_config_ttl(), (int)-1);
        this.addComment = cfg.include$_$filter_config_add__comment();
        this.includeTypeName = cfg.include$_$filter_config_include$_$type();
        this.requiredHeader = cfg.include$_$filter_config_required__header();
        this.ignoreUrlParams = new HashSet<String>(Arrays.asList(PropertiesUtil.toStringArray((Object)cfg.include$_$filter_config_ignoreUrlParams(), (String[])new String[0])));
        this.rewritePath = cfg.include$_$filter_config_rewrite();
        this.appendSuffix = cfg.include$_$filter_config_appendSuffix();
        this.disableIgnoreUrlParams = cfg.include$_$filter_config_disableIgnoreUrlParams();
    }

    private PathMatcher choosePathMatcher(String pathPattern) {
        PathMatcher result;
        if (pathPattern.startsWith("^")) {
            LOG.debug("Configured path value: {} is a regexp - will use a RegexPathMatcher.", (Object)pathPattern);
            result = new RegexPathMatcher(pathPattern);
        } else {
            LOG.debug("Configured path value: {} is NOT a regexp - will use a PrefixPathMatcher.", (Object)pathPattern);
            result = new PrefixPathMatcher(pathPattern);
        }
        return result;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public boolean hasIncludeSelector(SlingHttpServletRequest request) {
        return ArrayUtils.contains((Object[])request.getRequestPathInfo().getSelectors(), (Object)this.includeSelector);
    }

    public String getIncludeSelector() {
        return this.includeSelector;
    }

    public boolean hasExtension(SlingHttpServletRequest request) {
        String suffix = request.getRequestPathInfo().getSuffix();
        return suffix.endsWith("." + this.extension);
    }

    public boolean hasExtensionSet() {
        return StringUtils.isNotBlank((CharSequence)this.extension);
    }

    public String getExtension() {
        return this.extension;
    }

    public boolean hasTtlSet() {
        return this.ttl >= 0;
    }

    public int getTtl() {
        return this.ttl;
    }

    public boolean isSupportedResourceType(String resourceType) {
        return StringUtils.isNotBlank((CharSequence)resourceType) && this.resourceTypes.contains(resourceType);
    }

    public boolean getAddComment() {
        return this.addComment;
    }

    public String getIncludeTypeName() {
        return this.includeTypeName;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public String getRequiredHeader() {
        return this.requiredHeader;
    }

    public Collection<String> getIgnoreUrlParams() {
        return this.ignoreUrlParams;
    }

    public boolean isDisableIgnoreUrlParams() {
        return this.disableIgnoreUrlParams;
    }

    public boolean isRewritePath() {
        return this.rewritePath;
    }

    public boolean isAppendSuffix() {
        return this.appendSuffix;
    }

    @ObjectClassDefinition(name="Apache Sling Dynamic Include - Configuration")
    public static @interface Config {
        @AttributeDefinition(name="Enabled", description="Check to enable the filter")
        public boolean include$_$filter_config_enabled() default false;

        @AttributeDefinition(name="Base path regular expression", description="This SDI configuration will work only for paths matching this value. If value starts with \\\"^\\\" sign, regex matching will be performed. Otherwise it will check for path prefix.")
        public String include$_$filter_config_path() default "/content";

        @AttributeDefinition(name="Resource types", description="Filter will replace components with selected resource types", cardinality=0x7FFFFFFF)
        public String include$_$filter_config_resource$_$types() default "";

        @AttributeDefinition(name="Include type", description="Type of generated include tags", options={@Option(label="Apache SSI", value="SSI"), @Option(label="ESI", value="ESI"), @Option(label="Javascript", value="JSI")})
        public String include$_$filter_config_include$_$type() default "SSI";

        @AttributeDefinition(name="Add comment", description="Add comment to included components")
        public boolean include$_$filter_config_add__comment() default false;

        @AttributeDefinition(name="Filter selector", description="Selector used to mark included resources")
        public String include$_$filter_config_selector() default "nocache";

        @AttributeDefinition(name="Extension", description="Extension to append to virtual resources to make caching possible")
        public String include$_$filter_config_extension() default "";

        @AttributeDefinition(name="Component TTL", description="\"Time to live\" cache header for rendered component (in seconds)")
        public String include$_$filter_config_ttl() default "";

        @AttributeDefinition(name="Required header", description="SDI will work only for requests with given header")
        public String include$_$filter_config_required__header() default "Server-Agent=Communique-Dispatcher";

        @AttributeDefinition(name="Ignore URL params", description="SDI will process the request even if it contains configured GET parameters", cardinality=0x7FFFFFFF)
        public String include$_$filter_config_ignoreUrlParams() default "";

        @AttributeDefinition(name="Include path rewriting", description="Check to enable include path rewriting")
        public boolean include$_$filter_config_rewrite() default false;

        @AttributeDefinition(name="Append suffix to dynamic includes", description="Check to append the suffix of the parent request to the dynamic include.")
        public boolean include$_$filter_config_appendSuffix() default true;

        @AttributeDefinition(name="Disable ignore URL params check", description="Disable the check in the Ignore URL Params setting.")
        public boolean include$_$filter_config_disableIgnoreUrlParams() default false;
    }
}

