/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.dynamicinclude;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.dynamicinclude.Configuration;
import org.apache.sling.dynamicinclude.ConfigurationWhiteboard;

@Component(metatype=true, label="Apache Sling Dynamic Include - Synthetic Resource Filter")
@Service
@Properties(value={@Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="sling.filter.scope", value={"REQUEST"}, propertyPrivate=true), @Property(name="service.ranking", intValue={-2147483648}, propertyPrivate=false)})
public class SyntheticResourceFilter
implements Filter {
    @Reference
    private ConfigurationWhiteboard configurationWhiteboard;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
        String resourceType = SyntheticResourceFilter.getResourceTypeFromSuffix(slingRequest);
        Configuration config = this.configurationWhiteboard.getConfiguration(slingRequest, resourceType);
        if (config == null || !config.hasIncludeSelector(slingRequest) || !ResourceUtil.isSyntheticResource((Resource)slingRequest.getResource()) || config.hasExtensionSet() && !config.hasExtension(slingRequest)) {
            chain.doFilter(request, response);
            return;
        }
        RequestDispatcherOptions options = new RequestDispatcherOptions();
        options.setForceResourceType(resourceType);
        String resourcePath = StringUtils.substringBefore((String)slingRequest.getRequestPathInfo().getResourcePath(), (String)".");
        Resource resource = slingRequest.getResourceResolver().resolve(resourcePath);
        RequestDispatcher dispatcher = slingRequest.getRequestDispatcher(resource, options);
        dispatcher.forward(request, response);
    }

    private static String getResourceTypeFromSuffix(SlingHttpServletRequest request) {
        String suffix = request.getRequestPathInfo().getSuffix();
        suffix = StringUtils.substringBeforeLast((String)suffix, (String)".");
        return StringUtils.removeStart((String)suffix, (String)"/");
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    protected void bindConfigurationWhiteboard(ConfigurationWhiteboard configurationWhiteboard) {
        this.configurationWhiteboard = configurationWhiteboard;
    }

    protected void unbindConfigurationWhiteboard(ConfigurationWhiteboard configurationWhiteboard) {
        if (this.configurationWhiteboard == configurationWhiteboard) {
            this.configurationWhiteboard = null;
        }
    }
}

