/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.dynamicinclude;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.dynamicinclude.Configuration;

@Component
@Service(value={ConfigurationWhiteboard.class})
public class ConfigurationWhiteboard {
    @Reference(referenceInterface=Configuration.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private Set<Configuration> configs = new CopyOnWriteArraySet<Configuration>();

    public Configuration getConfiguration(SlingHttpServletRequest request, String resourceType) {
        for (Configuration c : this.configs) {
            if (!this.isEnabled(c, request) || !c.isSupportedResourceType(resourceType)) continue;
            return c;
        }
        return null;
    }

    private boolean isEnabled(Configuration config, SlingHttpServletRequest request) {
        String requestPath = request.getRequestPathInfo().getResourcePath();
        return config.isEnabled() && config.getPathMatcher().match(requestPath);
    }

    protected void bindConfigs(Configuration config) {
        this.configs.add(config);
    }

    protected void unbindConfigs(Configuration config) {
        this.configs.remove(config);
    }
}

