/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.dynamicinclude;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingFilter;
import org.apache.felix.scr.annotations.sling.SlingFilterScope;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.dynamicinclude.Configuration;
import org.apache.sling.dynamicinclude.ConfigurationWhiteboard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingFilter(scope={SlingFilterScope.REQUEST}, order=0)
public class CacheControlFilter
implements Filter {
    private static final String HEADER_DATE = "Date";
    private static final String HEADER_CACHE_CONTROL = "Cache-Control";
    private static final Logger LOG = LoggerFactory.getLogger(CacheControlFilter.class);
    @Reference
    private ConfigurationWhiteboard configurationWhiteboard;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
        String resourceType = slingRequest.getResource().getResourceType();
        Configuration config = this.configurationWhiteboard.getConfiguration(slingRequest, resourceType);
        if (config != null && config.hasTtlSet()) {
            SlingHttpServletResponse slingResponse = (SlingHttpServletResponse)response;
            slingResponse.setHeader(HEADER_CACHE_CONTROL, "max-age=" + config.getTtl());
            LOG.debug("set \"{}: max-age={}\" to {}", new Object[]{HEADER_CACHE_CONTROL, config.getTtl(), resourceType});
            if (!slingResponse.containsHeader(HEADER_DATE)) {
                slingResponse.setDateHeader(HEADER_DATE, System.currentTimeMillis());
            }
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    protected void bindConfigurationWhiteboard(ConfigurationWhiteboard configurationWhiteboard) {
        this.configurationWhiteboard = configurationWhiteboard;
    }

    protected void unbindConfigurationWhiteboard(ConfigurationWhiteboard configurationWhiteboard) {
        if (this.configurationWhiteboard == configurationWhiteboard) {
            this.configurationWhiteboard = null;
        }
    }
}

