/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.dynamicinclude.generator;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.dynamicinclude.generator.IncludeGenerator;

@Component
@Service(value={IncludeGeneratorWhiteboard.class})
public class IncludeGeneratorWhiteboard {
    @Reference(referenceInterface=IncludeGenerator.class, cardinality=ReferenceCardinality.MANDATORY_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private Set<IncludeGenerator> generators = new CopyOnWriteArraySet<IncludeGenerator>();

    public IncludeGenerator getGenerator(String type) {
        for (IncludeGenerator generator : this.generators) {
            if (!type.equals(generator.getType())) continue;
            return generator;
        }
        return null;
    }

    void bindGenerators(IncludeGenerator generator) {
        this.generators.add(generator);
    }

    void unbindGenerators(IncludeGenerator generator) {
        this.generators.remove(generator);
    }
}

