/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class PackageMessage {
    String pubSlingId;
    ReqType reqType;
    String pkgId;
    String pkgType;
    long pkgLength;
    byte[] pkgBinary;
    String pkgBinaryRef;
    String pubAgentName;
    String userId;
    List<String> paths;
    List<String> deepPaths;

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("PackageMessage(pubSlingId=");
        out.append(this.pubSlingId);
        out.append(", reqType=");
        out.append((Object)this.reqType);
        out.append(", pkgId=");
        out.append(this.pkgId);
        out.append(", pkgType=");
        out.append(this.pkgType);
        out.append(", pkgLength=");
        out.append(this.pkgLength);
        out.append(", pubAgentName=");
        out.append(this.pubAgentName);
        out.append(", userId=");
        out.append(this.userId);
        if (this.pkgBinary != null) {
            out.append(", pkgBinary.length=");
            out.append(this.pkgBinary.length);
        }
        out.append(", paths=");
        out.append(PackageMessage.abbreviate(this.paths));
        out.append(", deepPaths=");
        out.append(PackageMessage.abbreviate(this.deepPaths));
        out.append(")");
        return out.toString();
    }

    static String abbreviate(List<String> list) {
        if (list == null) {
            return null;
        }
        Iterator<String> iter = list.iterator();
        StringBuilder abbr = new StringBuilder();
        abbr.append("[");
        if (iter.hasNext()) {
            abbr.append(iter.next());
        }
        if (iter.hasNext()) {
            abbr.append(", ... ");
            abbr.append(list.size() - 1);
            abbr.append(" more");
        }
        abbr.append("]");
        return abbr.toString();
    }

    private static List<String> $default$paths() {
        return new ArrayList<String>();
    }

    private static List<String> $default$deepPaths() {
        return new ArrayList<String>();
    }

    public static PackageMessageBuilder builder() {
        return new PackageMessageBuilder();
    }

    public String getPubSlingId() {
        return this.pubSlingId;
    }

    public ReqType getReqType() {
        return this.reqType;
    }

    public String getPkgId() {
        return this.pkgId;
    }

    public String getPkgType() {
        return this.pkgType;
    }

    public long getPkgLength() {
        return this.pkgLength;
    }

    public byte[] getPkgBinary() {
        return this.pkgBinary;
    }

    public String getPkgBinaryRef() {
        return this.pkgBinaryRef;
    }

    public String getPubAgentName() {
        return this.pubAgentName;
    }

    public String getUserId() {
        return this.userId;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public List<String> getDeepPaths() {
        return this.deepPaths;
    }

    public void setPubSlingId(String pubSlingId) {
        this.pubSlingId = pubSlingId;
    }

    public void setReqType(ReqType reqType) {
        this.reqType = reqType;
    }

    public void setPkgId(String pkgId) {
        this.pkgId = pkgId;
    }

    public void setPkgType(String pkgType) {
        this.pkgType = pkgType;
    }

    public void setPkgLength(long pkgLength) {
        this.pkgLength = pkgLength;
    }

    public void setPkgBinary(byte[] pkgBinary) {
        this.pkgBinary = pkgBinary;
    }

    public void setPkgBinaryRef(String pkgBinaryRef) {
        this.pkgBinaryRef = pkgBinaryRef;
    }

    public void setPubAgentName(String pubAgentName) {
        this.pubAgentName = pubAgentName;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    public void setDeepPaths(List<String> deepPaths) {
        this.deepPaths = deepPaths;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PackageMessage)) {
            return false;
        }
        PackageMessage other = (PackageMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$pubSlingId = this.getPubSlingId();
        String other$pubSlingId = other.getPubSlingId();
        if (this$pubSlingId == null ? other$pubSlingId != null : !this$pubSlingId.equals(other$pubSlingId)) {
            return false;
        }
        ReqType this$reqType = this.getReqType();
        ReqType other$reqType = other.getReqType();
        if (this$reqType == null ? other$reqType != null : !((Object)((Object)this$reqType)).equals((Object)other$reqType)) {
            return false;
        }
        String this$pkgId = this.getPkgId();
        String other$pkgId = other.getPkgId();
        if (this$pkgId == null ? other$pkgId != null : !this$pkgId.equals(other$pkgId)) {
            return false;
        }
        String this$pkgType = this.getPkgType();
        String other$pkgType = other.getPkgType();
        if (this$pkgType == null ? other$pkgType != null : !this$pkgType.equals(other$pkgType)) {
            return false;
        }
        if (this.getPkgLength() != other.getPkgLength()) {
            return false;
        }
        if (!Arrays.equals(this.getPkgBinary(), other.getPkgBinary())) {
            return false;
        }
        String this$pkgBinaryRef = this.getPkgBinaryRef();
        String other$pkgBinaryRef = other.getPkgBinaryRef();
        if (this$pkgBinaryRef == null ? other$pkgBinaryRef != null : !this$pkgBinaryRef.equals(other$pkgBinaryRef)) {
            return false;
        }
        String this$pubAgentName = this.getPubAgentName();
        String other$pubAgentName = other.getPubAgentName();
        if (this$pubAgentName == null ? other$pubAgentName != null : !this$pubAgentName.equals(other$pubAgentName)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        List<String> this$paths = this.getPaths();
        List<String> other$paths = other.getPaths();
        if (this$paths == null ? other$paths != null : !((Object)this$paths).equals(other$paths)) {
            return false;
        }
        List<String> this$deepPaths = this.getDeepPaths();
        List<String> other$deepPaths = other.getDeepPaths();
        return !(this$deepPaths == null ? other$deepPaths != null : !((Object)this$deepPaths).equals(other$deepPaths));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PackageMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pubSlingId = this.getPubSlingId();
        result = result * 59 + ($pubSlingId == null ? 43 : $pubSlingId.hashCode());
        ReqType $reqType = this.getReqType();
        result = result * 59 + ($reqType == null ? 43 : ((Object)((Object)$reqType)).hashCode());
        String $pkgId = this.getPkgId();
        result = result * 59 + ($pkgId == null ? 43 : $pkgId.hashCode());
        String $pkgType = this.getPkgType();
        result = result * 59 + ($pkgType == null ? 43 : $pkgType.hashCode());
        long $pkgLength = this.getPkgLength();
        result = result * 59 + (int)($pkgLength >>> 32 ^ $pkgLength);
        result = result * 59 + Arrays.hashCode(this.getPkgBinary());
        String $pkgBinaryRef = this.getPkgBinaryRef();
        result = result * 59 + ($pkgBinaryRef == null ? 43 : $pkgBinaryRef.hashCode());
        String $pubAgentName = this.getPubAgentName();
        result = result * 59 + ($pubAgentName == null ? 43 : $pubAgentName.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        List<String> $paths = this.getPaths();
        result = result * 59 + ($paths == null ? 43 : ((Object)$paths).hashCode());
        List<String> $deepPaths = this.getDeepPaths();
        result = result * 59 + ($deepPaths == null ? 43 : ((Object)$deepPaths).hashCode());
        return result;
    }

    public PackageMessage() {
        this.paths = PackageMessage.$default$paths();
        this.deepPaths = PackageMessage.$default$deepPaths();
    }

    public PackageMessage(String pubSlingId, ReqType reqType, String pkgId, String pkgType, long pkgLength, byte[] pkgBinary, String pkgBinaryRef, String pubAgentName, String userId, List<String> paths, List<String> deepPaths) {
        this.pubSlingId = pubSlingId;
        this.reqType = reqType;
        this.pkgId = pkgId;
        this.pkgType = pkgType;
        this.pkgLength = pkgLength;
        this.pkgBinary = pkgBinary;
        this.pkgBinaryRef = pkgBinaryRef;
        this.pubAgentName = pubAgentName;
        this.userId = userId;
        this.paths = paths;
        this.deepPaths = deepPaths;
    }

    public static class PackageMessageBuilder {
        private String pubSlingId;
        private ReqType reqType;
        private String pkgId;
        private String pkgType;
        private long pkgLength;
        private byte[] pkgBinary;
        private String pkgBinaryRef;
        private String pubAgentName;
        private String userId;
        private boolean paths$set;
        private List<String> paths$value;
        private boolean deepPaths$set;
        private List<String> deepPaths$value;

        PackageMessageBuilder() {
        }

        public PackageMessageBuilder pubSlingId(String pubSlingId) {
            this.pubSlingId = pubSlingId;
            return this;
        }

        public PackageMessageBuilder reqType(ReqType reqType) {
            this.reqType = reqType;
            return this;
        }

        public PackageMessageBuilder pkgId(String pkgId) {
            this.pkgId = pkgId;
            return this;
        }

        public PackageMessageBuilder pkgType(String pkgType) {
            this.pkgType = pkgType;
            return this;
        }

        public PackageMessageBuilder pkgLength(long pkgLength) {
            this.pkgLength = pkgLength;
            return this;
        }

        public PackageMessageBuilder pkgBinary(byte[] pkgBinary) {
            this.pkgBinary = pkgBinary;
            return this;
        }

        public PackageMessageBuilder pkgBinaryRef(String pkgBinaryRef) {
            this.pkgBinaryRef = pkgBinaryRef;
            return this;
        }

        public PackageMessageBuilder pubAgentName(String pubAgentName) {
            this.pubAgentName = pubAgentName;
            return this;
        }

        public PackageMessageBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public PackageMessageBuilder paths(List<String> paths) {
            this.paths$value = paths;
            this.paths$set = true;
            return this;
        }

        public PackageMessageBuilder deepPaths(List<String> deepPaths) {
            this.deepPaths$value = deepPaths;
            this.deepPaths$set = true;
            return this;
        }

        public PackageMessage build() {
            List paths$value = this.paths$value;
            if (!this.paths$set) {
                paths$value = PackageMessage.$default$paths();
            }
            List deepPaths$value = this.deepPaths$value;
            if (!this.deepPaths$set) {
                deepPaths$value = PackageMessage.$default$deepPaths();
            }
            return new PackageMessage(this.pubSlingId, this.reqType, this.pkgId, this.pkgType, this.pkgLength, this.pkgBinary, this.pkgBinaryRef, this.pubAgentName, this.userId, paths$value, deepPaths$value);
        }

        public String toString() {
            return "PackageMessage.PackageMessageBuilder(pubSlingId=" + this.pubSlingId + ", reqType=" + (Object)((Object)this.reqType) + ", pkgId=" + this.pkgId + ", pkgType=" + this.pkgType + ", pkgLength=" + this.pkgLength + ", pkgBinary=" + Arrays.toString(this.pkgBinary) + ", pkgBinaryRef=" + this.pkgBinaryRef + ", pubAgentName=" + this.pubAgentName + ", userId=" + this.userId + ", paths$value=" + this.paths$value + ", deepPaths$value=" + this.deepPaths$value + ")";
        }
    }

    public static enum ReqType {
        ADD,
        DELETE,
        TEST;

    }
}

