/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.sling.distribution.journal;

import java.io.Closeable;
import java.util.function.Consumer;

import com.google.protobuf.GeneratedMessage;

public interface MessagingProvider {

    <T extends GeneratedMessage> MessageSender<T> createSender();
    
    /**
     * Create a sender for a fixed topic
     * 
     * @param <T>
     * @param topic
     * @return
     */
    default <T extends GeneratedMessage> Consumer<T> createSender(String topic) {
        MessageSender<GeneratedMessage> sender = createSender();
        return payload -> sender.send(topic, payload);
    }

    <T> Closeable createPoller(String topicName, Reset reset, HandlerAdapter<?>... adapters);

    Closeable createPoller(String topicName, Reset reset, String assign, HandlerAdapter<?>... adapters);

    <T> JsonMessageSender<T> createJsonSender();

    <T> Closeable createJsonPoller(String topicName, Reset reset, MessageHandler<T> handler, Class<T> type);

    void assertTopic(String topic) throws MessagingException;

    long retrieveOffset(String topicName, Reset reset);

    String assignTo(long offset);

}