/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal;

import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistryLite;
import java.lang.reflect.Method;
import org.apache.sling.distribution.journal.MessageHandler;
import org.apache.sling.distribution.journal.MessageInfo;

public class HandlerAdapter<T> {
    private final MessageHandler<T> handler;
    private final Method method;
    private final ExtensionRegistryLite registry;
    private final Class<T> type;

    public HandlerAdapter(Class<T> type, MessageHandler<T> handler) {
        this.type = type;
        this.handler = handler;
        try {
            this.method = type.getMethod("parseFrom", ByteString.class, ExtensionRegistryLite.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        this.registry = ExtensionRegistryLite.newInstance();
    }

    public static <T> HandlerAdapter<T> create(Class<T> type, MessageHandler<T> handler) {
        return new HandlerAdapter<T>(type, handler);
    }

    private T parseFrom(ByteString payloadBytes) throws Exception {
        return (T)this.method.invoke(null, payloadBytes, this.registry);
    }

    public void handle(MessageInfo info, ByteString payloadBytes) throws Exception {
        T payload = this.parseFrom(payloadBytes);
        this.handler.handle(info, payload);
    }

    public Class<?> getType() {
        return this.type;
    }

    public MessageHandler<T> getHandler() {
        return this.handler;
    }
}

