/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal;

import java.util.HashMap;
import javax.annotation.Nullable;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class ExceptionEventSender {
    public static final String ERROR_TOPIC = "org/apache/sling/distribution/journal/errors";
    public static final String KEY_MESSAGE = "message";
    public static final String KEY_TYPE = "type";
    private final EventAdmin eventAdmin;

    public ExceptionEventSender(@Nullable EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    private Event createErrorEvent(Exception e) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(KEY_TYPE, e.getClass().getName());
        props.put(KEY_MESSAGE, e.getMessage());
        return new Event(ERROR_TOPIC, props);
    }

    public void send(Exception e) {
        if (this.eventAdmin != null) {
            Event event = this.createErrorEvent(e);
            this.eventAdmin.postEvent(event);
        }
    }
}

