/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.subscriber;

import java.io.Closeable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.IOUtils;
import org.apache.sling.distribution.journal.HandlerAdapter;
import org.apache.sling.distribution.journal.MessageInfo;
import org.apache.sling.distribution.journal.MessagingProvider;
import org.apache.sling.distribution.journal.Reset;
import org.apache.sling.distribution.journal.impl.shared.Topics;
import org.apache.sling.distribution.journal.messages.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandPoller
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(CommandPoller.class);
    private final String subSlingId;
    private final String subAgentName;
    private final Closeable poller;
    private final AtomicLong clearOffset = new AtomicLong(-1L);

    public CommandPoller(MessagingProvider messagingProvider, Topics topics, String subSlingId, String subAgentName, boolean editable) {
        this.subSlingId = subSlingId;
        this.subAgentName = subAgentName;
        this.poller = editable ? messagingProvider.createPoller(topics.getCommandTopic(), Reset.earliest, new HandlerAdapter[]{HandlerAdapter.create(Messages.CommandMessage.class, this::handleCommandMessage)}) : null;
    }

    public boolean isCleared(long offset) {
        return offset <= this.clearOffset.longValue();
    }

    private void handleCommandMessage(MessageInfo info, Messages.CommandMessage message) {
        if (!this.subSlingId.equals(message.getSubSlingId()) || !this.subAgentName.equals(message.getSubAgentName())) {
            LOG.debug("Skip command for subSlingId {}", (Object)message.getSubSlingId());
            return;
        }
        if (message.hasClearCommand()) {
            this.handleClearCommand(message.getClearCommand().getOffset());
        } else {
            LOG.warn("Unsupported command {}", (Object)message);
        }
    }

    private void handleClearCommand(long offset) {
        long oldOffset = this.clearOffset.get();
        long newOffset = this.updateClearOffsetIfLarger(offset);
        LOG.info("Handled clear command for offset {}. Old clear offset was {}, new clear offset is {}.", new Object[]{offset, oldOffset, newOffset});
    }

    private long updateClearOffsetIfLarger(long offset) {
        return this.clearOffset.accumulateAndGet(offset, Math::max);
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.poller);
    }
}

